/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.vlog4j.parser.javacc;

import java.util.HashSet;
import org.semanticweb.vlog4j.core.model.api.Constant;
import org.semanticweb.vlog4j.core.model.api.DataSource;
import org.semanticweb.vlog4j.core.model.api.Predicate;
import org.semanticweb.vlog4j.core.model.api.PrefixDeclarations;
import org.semanticweb.vlog4j.core.model.api.Statement;
import org.semanticweb.vlog4j.core.model.implementation.DataSourceDeclarationImpl;
import org.semanticweb.vlog4j.core.model.implementation.Expressions;
import org.semanticweb.vlog4j.core.reasoner.KnowledgeBase;
import org.semanticweb.vlog4j.parser.LocalPrefixDeclarations;
import org.semanticweb.vlog4j.parser.javacc.ParseException;

public class JavaCCParserBase {
    final PrefixDeclarations prefixDeclarations = new LocalPrefixDeclarations();
    KnowledgeBase knowledgeBase;
    final HashSet<String> bodyVars = new HashSet();
    final HashSet<String> headExiVars = new HashSet();
    final HashSet<String> headUniVars = new HashSet();

    public JavaCCParserBase() {
        this.knowledgeBase = new KnowledgeBase();
    }

    Constant createIntegerLiteral(String lexicalForm) {
        return Expressions.makeConstant((String)(lexicalForm + "^^<" + "http://www.w3.org/2001/XMLSchema#integer" + ">"));
    }

    Constant createDecimalLiteral(String lexicalForm) {
        return Expressions.makeConstant((String)(lexicalForm + "^^<" + "http://www.w3.org/2001/XMLSchema#decimal" + ">"));
    }

    Constant createDoubleLiteral(String lexicalForm) {
        return Expressions.makeConstant((String)(lexicalForm + "^^<" + "http://www.w3.org/2001/XMLSchema#double" + ">"));
    }

    void addDataSource(String predicateName, int arity, DataSource dataSource) {
        Predicate predicate = Expressions.makePredicate((String)predicateName, (int)arity);
        this.knowledgeBase.addStatement((Statement)new DataSourceDeclarationImpl(predicate, dataSource));
    }

    static String unescapeStr(String s, int line, int column) throws ParseException {
        return JavaCCParserBase.unescape(s, '\\', false, line, column);
    }

    static String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) throws ParseException {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
            } else {
                if (i >= s.length() - 1) {
                    throw new ParseException("Illegal escape at end of string, line:" + line + ", column: " + column);
                }
                char ch2 = s.charAt(i + 1);
                ++column;
                ++i;
                char ch3 = '\u0000';
                switch (ch2) {
                    case 'n': {
                        ch3 = '\n';
                        break;
                    }
                    case 't': {
                        ch3 = '\t';
                        break;
                    }
                    case 'r': {
                        ch3 = '\r';
                        break;
                    }
                    case 'b': {
                        ch3 = '\b';
                        break;
                    }
                    case 'f': {
                        ch3 = '\f';
                        break;
                    }
                    case '\'': {
                        ch3 = '\'';
                        break;
                    }
                    case '\"': {
                        ch3 = '\"';
                        break;
                    }
                    case '\\': {
                        ch3 = '\\';
                        break;
                    }
                    default: {
                        throw new ParseException("Unknown escape: \\" + ch2 + ", line:" + line + ", column: " + column);
                    }
                }
                sb.append(ch3);
            }
            ++i;
        }
        return sb.toString();
    }

    static String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    static String stripQuotes3(String s) {
        return s.substring(3, s.length() - 3);
    }

    static String stripChars(String s, int n) {
        return s.substring(n, s.length());
    }

    String strRDFLiteral(String data, String lang, String dt) {
        String ret = "\"" + data + "\"";
        if (dt != null) {
            ret = ret + "^^" + dt;
            return ret;
        }
        if (lang != null) {
            ret = ret + "@" + lang;
            return ret;
        }
        return ret + "^^<http://www.w3.org/2001/XMLSchema#string>";
    }

    void resetVariableSets() {
        this.bodyVars.clear();
        this.headExiVars.clear();
        this.headUniVars.clear();
    }

    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public static enum FormulaContext {
        HEAD,
        BODY;

    }
}

