/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;

public class NodeArrayComparator
implements Comparator<Node[]>,
Serializable {
    public static final int NOT_EQUALS_COMP = -2147480429;
    private static Logger _log = Logger.getLogger(NodeArrayComparator.class.getName());
    private static final long serialVersionUID = 1L;
    private boolean _variableLength = true;
    private boolean _nZero = false;
    private boolean _nEquals = false;
    private boolean[] _numeric = null;
    private boolean[] _reverse = null;
    private int[] _order = null;
    private int _n = Integer.MAX_VALUE;
    public static final NodeArrayComparator NC_VAR = new NodeArrayComparator(true);
    public static final NodeArrayComparator NC = new NodeArrayComparator(false);

    public NodeArrayComparator(boolean variableLength) {
        this._variableLength = variableLength;
    }

    public NodeArrayComparator(boolean notZero, boolean notEqual) {
        this._nZero = notZero;
        this._nEquals = notEqual;
    }

    public NodeArrayComparator(int n) {
        this._n = n;
    }

    public NodeArrayComparator(int[] order) {
        this._order = order;
    }

    public NodeArrayComparator() {
    }

    public NodeArrayComparator(NodeArrayComparatorArgs nca) {
        this._variableLength = nca._varLength;
        this._nZero = nca._nZero;
        this._nEquals = nca._nEquals;
        this._numeric = nca._numeric;
        this._reverse = nca._reverse;
        this._order = nca._order;
        this._n = nca._n;
    }

    @Override
    public int compare(Node[] n1, Node[] n2) {
        int dif;
        if (n1 == n2) {
            return 0;
        }
        int min = Math.min(Math.min(n1.length, n2.length), this._n);
        for (int i = 0; i < min; ++i) {
            if (this._order != null) {
                if (this._order.length == i) {
                    if (this._nZero) {
                        return -2147480429;
                    }
                    return 0;
                }
                int index = this._order[i];
                if (index >= n1.length || index >= n2.length) {
                    _log.warning("Cannot compare " + Nodes.toString((Node[])n1) + " with " + Nodes.toString((Node[])n2) + " for order " + this._order);
                    return Integer.MIN_VALUE;
                }
                int comp = this.compare(n1[index], n2[index], this._numeric != null && this._numeric.length > index && this._numeric[index], this._reverse != null && this._reverse.length > index && this._reverse[index]);
                if (comp == 0) continue;
                return comp;
            }
            int comp = n1[i].compareTo((Object)n2[i]);
            if (comp == 0) continue;
            return comp;
        }
        if (!this._variableLength && (dif = n1.length - n2.length) != 0) {
            return dif;
        }
        if (this._nZero) {
            return -2147480429;
        }
        return 0;
    }

    private int compare(Node a, Node b, boolean numeric, boolean reverse) throws NumberFormatException {
        int comp;
        if (!numeric) {
            comp = a.compareTo((Object)b);
        } else {
            double da = Double.parseDouble(a.toString());
            double db = Double.parseDouble(b.toString());
            comp = Double.compare(da, db);
        }
        if (reverse) {
            comp *= -1;
        }
        return comp;
    }

    public boolean equals(Node[] n1, Node[] n2) {
        int dif;
        if (n1 == n2) {
            return true;
        }
        if (this._nEquals) {
            return false;
        }
        if (!this._variableLength && (dif = n2.length - n1.length) != 0) {
            return false;
        }
        for (int i = 0; i < Math.min(Math.min(n1.length, n2.length), this._n); ++i) {
            if (this._order != null) {
                if (this._order.length == i) {
                    return true;
                }
                int index = this._order[i];
                if (index >= n1.length || index >= n2.length) {
                    _log.warning("Cannot compare " + Nodes.toString((Node[])n1) + " with " + Nodes.toString((Node[])n2) + " for order " + this._order);
                    return false;
                }
                if (n1[index].equals((Object)n2[index])) continue;
                return false;
            }
            if (n1[i].equals((Object)n2[i])) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        BNode a = new BNode("a");
        BNode b = new BNode("b");
        BNode c = new BNode("c");
        Node[] na = new Node[]{a};
        Node[] nab = new Node[]{a, b};
        Node[] nabc = new Node[]{a, b, c};
        Node[] nc = new Node[]{c};
        Node[] nccc = new Node[]{c, c, c};
        TreeSet<Node[]> sorted = new TreeSet<Node[]>(NC);
        sorted.add(na);
        sorted.add(nab);
        sorted.add(nabc);
        sorted.add(nc);
        sorted.add(nccc);
        Iterator<Node[]> iter = sorted.iterator();
        while (iter.hasNext()) {
            System.err.println(Nodes.toString((Node[])iter.next()));
        }
    }

    public static final class NodeArrayComparatorArgs {
        boolean _varLength = false;
        boolean _nZero = false;
        boolean _nEquals = false;
        boolean[] _numeric = null;
        boolean[] _reverse = null;
        int[] _order = null;
        int _n = Integer.MAX_VALUE;

        public void setVarLength(boolean varLength) {
            this._varLength = varLength;
        }

        public void setNoZero(boolean nZero) {
            this._nZero = nZero;
        }

        public void setNoEquals(boolean nEquals) {
            this._nEquals = nEquals;
        }

        public void setNumeric(boolean[] numeric) {
            this._numeric = numeric;
        }

        public void setReverse(boolean[] reverse) {
            this._reverse = reverse;
        }

        public void setOrder(int[] order) {
            this._order = order;
        }

        public void setCompareMax(int n) {
            this._n = n;
        }
    }
}

