/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.reorder;

import java.util.Iterator;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;

public class ReorderIterator
implements Iterator<Node[]> {
    static transient Logger _log = Logger.getLogger(ReorderIterator.class.getName());
    private final Iterator<Node[]> _in;
    private final int[] _order;
    private final int _ticks;
    private long _count;

    public ReorderIterator(Iterator<Node[]> in, int[] order) {
        this(in, order, 0);
    }

    public ReorderIterator(Iterator<Node[]> in, int[] order, int ticks) {
        this._in = in;
        this._order = order;
        this._ticks = ticks;
        this._count = 0L;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    @Override
    public Node[] next() {
        ++this._count;
        if (this._ticks > 0 && this._count % (long)this._ticks == 0L) {
            _log.info("Reordered " + this._count + " statements.");
        }
        return ReorderIterator.reorder(this._in.next(), this._order);
    }

    @Override
    public void remove() {
        this._in.remove();
    }

    public long count() {
        return this._count;
    }

    public static Node[] reorder(Node[] nx, int[] order) {
        Node[] nxout = new Node[order.length];
        for (int i = 0; i < order.length; ++i) {
            nxout[i] = nx[order[i]];
        }
        return nxout;
    }

    public static int[] getInvOrder(int[] order) {
        int[] invOrder = new int[order.length];
        for (int i = 0; i < order.length; ++i) {
            invOrder[order[i]] = i;
        }
        return invOrder;
    }
}

