/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.sort;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeArrayComparator;
import org.semanticweb.yars.nx.mem.LowMemorySniffer;
import org.semanticweb.yars.nx.mem.MemoryManager;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.sort.MergeSortIterator;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;
import org.semanticweb.yars.util.FlyweightNodeIterator;
import org.semanticweb.yars.util.PleaseCloseTheDoorWhenYouLeaveIterator;
import org.semanticweb.yars.util.SniffNodeArrayLengthIterator;

public class SortIterator
implements Iterator<Node[]>,
Iterable<Node[]> {
    public static final String PREFIX = "batch";
    public static final String SUFFIX = ".nq.gz";
    private static final int INTERNAL_BATCH = 5000;
    private static final double KILL_SLOW_RATIO = 4.0;
    private static final int IN_A_ROW = 3;
    static transient Logger _log = Logger.getLogger(SortIterator.class.getName());
    private MergeSortIterator _merge = null;
    private Iterator<Node[]> _single = null;
    private long _dupes;
    private long _count = 0L;

    public SortIterator(Iterator<Node[]> in) throws IOException, ParseException {
        this(new SortArgs(in));
    }

    public SortIterator(Iterator<Node[]> in, short nxlength) throws IOException, ParseException {
        this(new SortArgs(in, nxlength));
    }

    public SortIterator(SortArgs args) throws IOException, ParseException {
        this.sort(args);
    }

    private void sort(SortArgs args) throws IOException, ParseException {
        long count = 0L;
        int i = 0;
        long dupes = 0L;
        LowMemorySniffer lms = null;
        if (args._linesPerBatch == Integer.MIN_VALUE) {
            lms = new LowMemorySniffer();
        }
        if (lms == null) {
            _log.info("Using batches with " + args._linesPerBatch + " statements each.");
        } else {
            _log.info("Using adaptive batches.");
        }
        Iterator in = args._in;
        if (args._fw > 0) {
            in = new FlyweightNodeIterator(args._fw, (Iterator<Node[]>)in);
        }
        LinkedList<Path> tempFiles = new LinkedList<Path>();
        Iterator one = null;
        while (in.hasNext()) {
            TreeSet<Node[]> sset = new TreeSet<Node[]>(args._nc);
            long b4 = System.currentTimeMillis();
            long fastest = Long.MAX_VALUE;
            int in_a_row = 0;
            while (in.hasNext() && (lms != null && !lms.lowMemory() || lms == null && sset.size() < args._linesPerBatch)) {
                Node[] quad = (Node[])in.next();
                boolean notdupe = sset.add(quad);
                if (!notdupe) {
                    ++dupes;
                }
                if (args._ticks > 0 && ++count % (long)args._ticks == 0L) {
                    _log.info("Batched " + count + " in " + i + " files with " + dupes + " duplicates.");
                }
                if (lms == null || count % 5000L != 0L) continue;
                long t = System.currentTimeMillis() - b4;
                b4 = System.currentTimeMillis();
                if (t < fastest) {
                    fastest = t;
                    in_a_row = 0;
                    continue;
                }
                if ((double)fastest * 4.0 < (double)t) {
                    if (++in_a_row < 3) continue;
                    _log.info("Slow mini-batch #" + in_a_row + " " + t + " vs. " + fastest + " fastest... batch size: " + sset.size());
                    break;
                }
                in_a_row = 0;
            }
            Iterator it = sset.iterator();
            if (!args._in.hasNext() && i == 0) {
                one = it;
                break;
            }
            Path temp = Files.createTempFile(args._tmpDir, PREFIX + i, SUFFIX, new FileAttribute[0]);
            tempFiles.add(temp);
            temp.toFile().deleteOnExit();
            OutputStream os = Files.newOutputStream(temp, new OpenOption[0]);
            if (args._gzipBatch) {
                os = new GZIPOutputStream(os);
            }
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
            CallbackNxBufferedWriter cbBatch = new CallbackNxBufferedWriter(bw);
            ++i;
            _log.info("Dumping batch size: " + sset.size());
            cbBatch.startDocument();
            while (it.hasNext()) {
                Node[] quad = (Node[])it.next();
                cbBatch.processStatement(quad);
            }
            cbBatch.endDocument();
            bw.close();
            os.close();
            _log.info("Parsed and sorted " + count + " lines in " + i + " files with " + dupes + " duplicates.");
        }
        if (i > 0) {
            _log.info("Merging " + i + " segment files.");
            ArrayList<PleaseCloseTheDoorWhenYouLeaveIterator> tempFileIterators = new ArrayList<PleaseCloseTheDoorWhenYouLeaveIterator>();
            for (Path tempFilePath : tempFiles) {
                InputStream is = Files.newInputStream(tempFilePath, StandardOpenOption.READ);
                if (args._gzipBatch) {
                    is = new GZIPInputStream(is, 8192);
                }
                NxParser nxp = new NxParser();
                nxp.parse(is, StandardCharsets.UTF_8);
                PleaseCloseTheDoorWhenYouLeaveIterator it = new PleaseCloseTheDoorWhenYouLeaveIterator((Iterator)nxp, (Closeable)is);
                tempFileIterators.add(it);
            }
            MergeSortIterator.MergeSortArgs msa = new MergeSortIterator.MergeSortArgs(tempFileIterators.toArray(new Iterator[0]));
            msa.setComparator(args._nc);
            msa.setDuplicates(dupes);
            msa.setTicks(args._ticks);
            this._merge = new MergeSortIterator(msa);
            this._dupes = this._merge.duplicates();
            for (Path tempFilePath : tempFiles) {
                tempFilePath.toFile().delete();
            }
            args._tmpDir.toFile().delete();
        } else if (one != null) {
            this._single = one;
            this._dupes = dupes;
        }
    }

    public long duplicates() {
        if (this._merge == null && this._single == null) {
            return 0L;
        }
        if (this._merge != null) {
            return this._merge.duplicates();
        }
        return this._dupes;
    }

    public long count() {
        return this._count;
    }

    @Override
    public boolean hasNext() {
        if (this._merge == null && this._single == null) {
            return false;
        }
        if (this._merge != null) {
            return this._merge.hasNext();
        }
        return this._single.hasNext();
    }

    @Override
    public Node[] next() {
        if (this._merge == null && this._single == null) {
            throw new NoSuchElementException();
        }
        if (this._merge != null) {
            ++this._count;
            return this._merge.next();
        }
        ++this._count;
        return this._single.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Node[]> iterator() {
        return this;
    }

    public static class SortArgs {
        public static final int DEFAULT_FW = 0;
        public static final boolean DEFAULT_GZIP_BATCH = true;
        public static final int ADAPTIVE_BATCHES = Integer.MIN_VALUE;
        private final Iterator<Node[]> _in;
        private final short _nxlength;
        private int _linesPerBatch;
        private Comparator<Node[]> _nc;
        private Path _tmpDir;
        private boolean _gzipBatch = true;
        private int _ticks = 0;
        private int _fw = 0;

        public SortArgs(Iterator<Node[]> in) {
            SniffNodeArrayLengthIterator si;
            this._in = si = new SniffNodeArrayLengthIterator(in);
            this._nxlength = si.nxLength();
            this.initDefaults(this._nxlength);
        }

        public SortArgs(Iterator<Node[]> in, short nxlength) {
            this._in = in;
            this._nxlength = nxlength;
            this.initDefaults(nxlength);
        }

        public SortArgs(Iterator<Node[]> in, short nxlength, int linesPerBatch) {
            this._in = in;
            this._nxlength = nxlength;
            this._linesPerBatch = linesPerBatch;
            this._nc = NodeArrayComparator.NC;
            try {
                this._tmpDir = Files.createTempDirectory(SortIterator.PREFIX, new FileAttribute[0]);
                this._tmpDir.toFile().deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this._ticks = 0;
            this._fw = 0;
        }

        private void initDefaults(int nxlength) {
            this._nc = NodeArrayComparator.NC;
            try {
                this._tmpDir = Files.createTempDirectory(SortIterator.PREFIX, new FileAttribute[0]);
                this._tmpDir.toFile().deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this._ticks = 0;
            this._fw = 0;
            this._linesPerBatch = this._nxlength > 0 ? MemoryManager.estimateMaxStatements(nxlength) : 1;
        }

        public void setComparator(Comparator<Node[]> nc) {
            this._nc = nc;
        }

        public void setAdaptiveBatches() {
            this._linesPerBatch = Integer.MIN_VALUE;
        }

        public void setLinesPerBatch(int linesPerBatch) {
            this._linesPerBatch = linesPerBatch;
        }

        public void setGzipBatches(boolean gzbat) {
            this._gzipBatch = gzbat;
        }

        public void setTicks(int ticks) {
            this._ticks = ticks;
        }

        public void setFlyWeight(int fw) {
            this._fw = fw;
        }
    }
}

