/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.Map;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.util.LRUMapCache;

public class FlyweightNodeIterator
implements Iterator<Node[]> {
    Map<Node, Node> _flyweight;
    Iterator<Node[]> _in;

    public FlyweightNodeIterator(int size, Iterator<Node[]> in) {
        this((Map<Node, Node>)new LRUMapCache(size), in);
    }

    public FlyweightNodeIterator(Map<Node, Node> flyweightMap, Iterator<Node[]> in) {
        this._flyweight = flyweightMap;
        this._in = in;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    @Override
    public Node[] next() {
        Node[] next = this._in.next();
        Node[] fwa = new Node[next.length];
        for (int i = 0; i < next.length; ++i) {
            fwa[i] = this.flyweight(next[i]);
        }
        return fwa;
    }

    private Node flyweight(Node n) {
        Node fw = this._flyweight.get(n);
        if (fw == null) {
            this._flyweight.put(n, n);
            return n;
        }
        return fw;
    }

    @Override
    public void remove() {
        this._in.remove();
    }
}

