/*
 * Decompiled with CFR 0.152.
 */
package org.semispace;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.semispace.SemiEventListener;
import org.semispace.event.SemiAvailabilityEvent;
import org.semispace.event.SemiEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemiBlockingListener
implements SemiEventListener {
    private static final Logger log = LoggerFactory.getLogger(SemiBlockingListener.class);
    private transient long msToWait;
    private transient CountDownLatch latch;
    private transient Boolean beenNotified;

    public SemiBlockingListener(long msToWait) {
        this.msToWait = msToWait;
        this.beenNotified = Boolean.FALSE;
    }

    public void notify(SemiEvent theEvent) {
        if (theEvent instanceof SemiAvailabilityEvent) {
            this.beenNotified = Boolean.TRUE;
            this.unblock();
        }
    }

    private void unblock() {
        if (this.latch != null) {
            this.latch.countDown();
            this.msToWait = -1L;
        }
    }

    public void block() {
        this.latch = new CountDownLatch(1);
        try {
            if (!this.beenNotified.booleanValue()) {
                this.latch.await(this.msToWait, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.error("Got interrupted exception (which unblocks await)");
        }
    }

    public boolean hasBeenNotified() {
        return this.beenNotified;
    }
}

