/*
 * Decompiled with CFR 0.152.
 */
package org.semispace;

import com.thoughtworks.xstream.XStream;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.beanutils.PropertyUtils;
import org.semispace.ElementLease;
import org.semispace.EventDistributor;
import org.semispace.Holder;
import org.semispace.HolderContainer;
import org.semispace.HolderElement;
import org.semispace.ListenerHolder;
import org.semispace.ListenerLease;
import org.semispace.SemiBlockingListener;
import org.semispace.SemiEventListener;
import org.semispace.SemiEventRegistration;
import org.semispace.SemiLease;
import org.semispace.SemiSpaceInterface;
import org.semispace.SemiSpaceStatistics;
import org.semispace.admin.InternalQuery;
import org.semispace.admin.SemiSpaceAdmin;
import org.semispace.admin.SemiSpaceAdminInterface;
import org.semispace.event.SemiAvailabilityEvent;
import org.semispace.event.SemiEvent;
import org.semispace.event.SemiExpirationEvent;
import org.semispace.event.SemiRenewalEvent;
import org.semispace.event.SemiTakenEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemiSpace
implements SemiSpaceInterface {
    private static final String ADMIN_GROUP_IS_FLAGGED = "adminGroupIsFlagged";
    private static final Logger log = LoggerFactory.getLogger(SemiSpace.class);
    public static final long ONE_DAY = 86400000L;
    private static SemiSpace instance = null;
    private long holderId = 0L;
    private long listenerId = 0L;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private HolderContainer elements = null;
    private transient Map<Long, ListenerHolder> listeners;
    private transient SemiSpaceAdminInterface admin;
    private SemiSpaceStatistics statistics;
    private transient XStream xStream;
    private Set<String> checkedClassSet = new HashSet<String>();

    private SemiSpace() {
        this.elements = HolderContainer.retrieveContainer();
        this.listeners = new ConcurrentHashMap<Long, ListenerHolder>();
        this.statistics = new SemiSpaceStatistics();
        this.setAdmin(new SemiSpaceAdmin(this));
        this.xStream = new XStream();
    }

    public void initTransients() {
        SemiSpace.instance.listeners = new ConcurrentHashMap<Long, ListenerHolder>();
        instance.setAdmin(new SemiSpaceAdmin(this));
        SemiSpace.instance.xStream = new XStream();
    }

    public static synchronized SemiSpaceInterface retrieveSpace() {
        if (instance == null) {
            instance = new SemiSpace();
        }
        if (!SemiSpace.instance.admin.hasBeenInitialized()) {
            SemiSpace.instance.admin.performInitialization();
        }
        return instance;
    }

    @Override
    public SemiEventRegistration notify(Object tmpl, SemiEventListener listener, long duration) {
        if (tmpl == null) {
            log.warn("Not registering notification on null object.");
            return null;
        }
        Map<String, String> searchProps = this.retrievePropertiesFromObject(tmpl);
        SemiEventRegistration registration = this.notify(searchProps, listener, duration);
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SemiEventRegistration notify(Map<String, String> searchProps, SemiEventListener listener, long duration) {
        if (listener == null) {
            log.warn("Not allowing listener to be null.");
            return null;
        }
        if (searchProps == null) {
            log.warn("Not allowing search props to be null");
            return null;
        }
        if (duration <= 0L) {
            log.warn("Not registering notification when duration is <= 0. It was " + duration);
            return null;
        }
        SemiEventRegistration eventRegistration = null;
        this.rwl.writeLock().lock();
        ListenerHolder holder = null;
        try {
            ++this.listenerId;
            holder = new ListenerHolder(this.listenerId, listener, duration + this.admin.calculateTime(), searchProps);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        if (this.listeners.put(holder.getId(), holder) != null) {
            throw new RuntimeException("Internal assertion error. Listener map already had element with id " + holder.getId());
        }
        this.statistics.increaseNumberOfListeners();
        ListenerLease lease = new ListenerLease(holder, this);
        eventRegistration = new SemiEventRegistration(holder.getId(), lease);
        return eventRegistration;
    }

    private void notifyListeners(EventDistributor distributedEvent) {
        final ArrayList<SemiEventListener> toNotify = new ArrayList<SemiEventListener>();
        for (ListenerHolder listener : this.listeners.values()) {
            if (listener.getLiveUntil() < this.admin.calculateTime()) {
                this.cancelListener(listener);
                continue;
            }
            if (!this.hasSubSet(distributedEvent.getEntrySet(), listener.getSearchMap())) continue;
            SemiEventListener notifyMe = listener.getListener();
            toNotify.add(notifyMe);
        }
        final SemiEvent event = distributedEvent.getEvent();
        Runnable notifyThread = new Runnable(){

            public void run() {
                for (SemiEventListener notify : toNotify) {
                    notify.notify(event);
                }
            }
        };
        this.admin.getThreadPool().execute(notifyThread);
        this.admin.notifyAboutEvent(distributedEvent);
    }

    @Override
    public SemiLease write(Object entry, long leaseTimeMs) {
        if (entry == null) {
            return null;
        }
        WrappedInternalWriter write = new WrappedInternalWriter(entry, leaseTimeMs);
        Future<?> future = this.admin.getThreadPool().submit(write);
        Exception exception = null;
        try {
            future.get();
        }
        catch (InterruptedException e) {
            log.error("Got exception", (Throwable)e);
            exception = e;
        }
        catch (ExecutionException e) {
            log.error("Got exception", (Throwable)e);
            exception = e;
        }
        if (write.getException() != null || exception != null) {
            String error = " Writing object (of type " + entry.getClass().getName() + ") to space gave exception. XML version: " + this.objectToXml(entry);
            if (write.getException() != null) {
                exception = write.getException();
            }
            throw new RuntimeException(error, exception);
        }
        return write.getLease();
    }

    private SemiLease writeInternally(Object entry, long leaseTimeMs) {
        String entryClassName = entry.getClass().getName();
        if (entry instanceof InternalQuery) {
            entryClassName = InternalQuery.class.getName();
        }
        String xml = this.objectToXml(entry);
        Map<String, String> searchMap = this.retrievePropertiesFromObject(entry);
        return this.writeToElements(entryClassName, leaseTimeMs, xml, searchMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SemiLease writeToElements(String entryClassName, long leaseTimeMs, String xml, Map<String, String> searchMap) {
        Holder holder = null;
        this.rwl.writeLock().lock();
        try {
            ++this.holderId;
            if (!this.checkedClassSet.contains(entryClassName) && xml.contains("<outer-class>")) {
                this.checkedClassSet.add(entryClassName);
                log.warn("It seems that " + entryClassName + " is an inner class. This is DISCOURAGED as it WILL serialize the outher " + "class as well. If you did not intend this, note that what you store MAY be significantly larger than you " + "expected. This warning is printed once for each class type.");
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        holder = new Holder(xml, this.admin.calculateTime() + leaseTimeMs, entryClassName, this.holderId, searchMap);
        this.elements.addHolder(holder);
        ElementLease lease = new ElementLease(holder, this);
        this.statistics.increaseWrite();
        SemiAvailabilityEvent semiEvent = new SemiAvailabilityEvent(holder.getId());
        this.notifyListeners(new EventDistributor(holder.getClassName(), semiEvent, holder.getSearchMap()));
        return lease;
    }

    @Override
    public Object read(Object tmpl, long timeout) {
        String found = null;
        if (tmpl != null) {
            found = this.findOrWaitLeaseForTemplate(this.retrievePropertiesFromObject(tmpl), timeout, false);
        }
        return this.xmlToObject(found);
    }

    public String findOrWaitLeaseForTemplate(Map<String, String> templateSet, long timeout, boolean isToTakeTheLease) {
        String found = this.findLeaseForTemplate(templateSet, isToTakeTheLease);
        if (found == null && timeout > 0L) {
            long until = this.admin.calculateTime() + timeout;
            long subtract = 0L;
            while (found == null && this.admin.calculateTime() < until) {
                long systime = this.admin.calculateTime();
                SemiBlockingListener listener = new SemiBlockingListener(timeout);
                if (isToTakeTheLease) {
                    this.statistics.increaseBlockingTake();
                } else {
                    this.statistics.increaseBlockingRead();
                }
                SemiEventRegistration eventReg = this.notify(templateSet, (SemiEventListener)listener, timeout - subtract);
                listener.block();
                eventReg.getLease().cancel();
                if (isToTakeTheLease) {
                    this.statistics.decreaseBlockingTake();
                } else {
                    this.statistics.decreaseBlockingRead();
                }
                if (listener.hasBeenNotified()) {
                    found = this.findLeaseForTemplate(templateSet, isToTakeTheLease);
                }
                subtract += this.admin.calculateTime() - systime;
            }
        }
        return found;
    }

    @Override
    public Object readIfExists(Object tmpl) {
        return this.read(tmpl, 0L);
    }

    private String findLeaseForTemplate(Map<String, String> templateSet, boolean isToTakeTheLease) {
        Holder found = null;
        ArrayList<Holder> toEvict = new ArrayList<Holder>();
        if (templateSet.get("class") == null) {
            throw new RuntimeException("Did not expect classname to be null");
        }
        String className = templateSet.get("class");
        if (templateSet.get(ADMIN_GROUP_IS_FLAGGED) != null) {
            className = InternalQuery.class.getName();
        }
        for (HolderElement next = this.elements.next(className); found == null && next != null; next = next.next()) {
            Holder elem = next.getHolder();
            if (elem.getLiveUntil() < this.admin.calculateTime()) {
                toEvict.add(elem);
                elem = null;
            }
            if (elem == null || !this.hasSubSet(elem.getSearchMap().entrySet(), templateSet)) continue;
            found = elem;
        }
        boolean needToRetake = false;
        for (Holder evict : toEvict) {
            if (this.cancelElement(evict.getId(), false, evict.getClassName())) continue;
            log.debug("Element with id " + evict.getId() + " should exist in most cases. This time, it is probably missing as it belongs to a timed out query.");
        }
        if (found != null && isToTakeTheLease && !this.cancelElement(found.getId(), isToTakeTheLease, found.getClassName())) {
            log.info("Element with id " + found.getId() + " ceased to exist during take. " + "This is not an error; Just an indication of a busy space. ");
            found = null;
            needToRetake = true;
        }
        if (needToRetake) {
            return this.findLeaseForTemplate(templateSet, isToTakeTheLease);
        }
        if (found != null) {
            if (isToTakeTheLease) {
                this.statistics.increaseTake();
            } else {
                this.statistics.increaseRead();
            }
        } else if (isToTakeTheLease) {
            this.statistics.increaseMissedTake();
        } else {
            this.statistics.increaseMissedRead();
        }
        if (found != null) {
            return found.getXml();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Holder readHolderById(long hId) {
        Holder result = null;
        this.rwl.readLock().lock();
        try {
            result = this.elements.readHolderWithId(hId);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return result;
    }

    private boolean hasSubSet(Set<Map.Entry<String, String>> containerEntrySet, Map<String, String> templateSubSet) {
        if (templateSubSet == null) {
            throw new RuntimeException("Did not expect template sub set to be null");
        }
        Set<Map.Entry<String, String>> templateEntrySet = templateSubSet.entrySet();
        return containerEntrySet.containsAll(templateEntrySet);
    }

    @Override
    public Object take(Object tmpl, long timeout) {
        String found = null;
        if (tmpl != null) {
            found = this.findOrWaitLeaseForTemplate(this.retrievePropertiesFromObject(tmpl), timeout, true);
        }
        return this.xmlToObject(found);
    }

    @Override
    public Object takeIfExists(Object tmpl) {
        return this.take(tmpl, 0L);
    }

    private String objectToXml(Object obj) {
        return this.xStream.toXML(obj);
    }

    private Object xmlToObject(String xml) {
        if (xml == null || "".equals(xml)) {
            return null;
        }
        Object result = null;
        try {
            result = this.xStream.fromXML(xml);
        }
        catch (Exception e) {
            log.error("Got exception unmarshalling. Not throwing the exception up, but rather returning null. This is as the cause may be a change in the object which is sent over. The XML was read as\n" + xml, (Throwable)e);
        }
        return result;
    }

    protected Map<String, String> retrievePropertiesFromObject(Object examine) {
        Field[] fields = examine.getClass().getFields();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String name = fields[i].getName();
                Object value = fields[i].get(examine);
                if (value == null) continue;
                map.put(name, "" + value);
                continue;
            }
            catch (IllegalAccessException e) {
                log.warn("Introspection gave exception", (Throwable)e);
            }
        }
        PropertyDescriptor[] desc = PropertyUtils.getPropertyDescriptors((Object)examine);
        for (int i = 0; i < desc.length; ++i) {
            Method readMethod = desc[i].getReadMethod();
            Object value = null;
            try {
                String name = desc[i].getName();
                if (readMethod == null || (value = PropertyUtils.getProperty((Object)examine, (String)desc[i].getName())) == null) continue;
                map.put(name, "" + value);
                continue;
            }
            catch (IllegalAccessException e) {
                log.error("Got exception examining object.", (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                log.error("Got exception examining object.", (Throwable)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                log.error("Got exception examining object.", (Throwable)e);
            }
        }
        if (examine instanceof InternalQuery) {
            map.put(ADMIN_GROUP_IS_FLAGGED, "true");
        }
        String className = (String)map.remove("class");
        map.put("class", className.substring("class ".length()));
        return map;
    }

    public void setAdmin(SemiSpaceAdminInterface admin) {
        this.admin = admin;
    }

    public SemiSpaceAdminInterface getAdmin() {
        return this.admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void harvest() {
        for (ListenerHolder listener : this.listeners.values()) {
            if (listener.getLiveUntil() >= this.admin.calculateTime()) continue;
            this.cancelListener(listener);
        }
        ArrayList<Holder> beforeEvict = new ArrayList<Holder>();
        this.rwl.readLock().lock();
        try {
            String[] groups;
            for (String group : groups = this.elements.retrieveGroupNames()) {
                int evictSize = beforeEvict.size();
                for (HolderElement next = this.elements.next(group); next != null; next = next.next()) {
                    Holder elem = next.getHolder();
                    if (elem.getLiveUntil() >= this.admin.calculateTime()) continue;
                    beforeEvict.add(elem);
                }
                long afterSize = beforeEvict.size() - evictSize;
                if (afterSize <= 0L) continue;
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Holder evict : beforeEvict) {
                    ids.add(evict.getId());
                }
                String moreInfo = "";
                if (ids.size() < 30) {
                    Collections.sort(ids);
                    moreInfo = "Ids: " + ids;
                }
                log.debug("Testing group " + group + " gave " + afterSize + " element(s) to evict. " + moreInfo);
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        for (Holder evict : beforeEvict) {
            this.cancelElement(evict.getId(), false, evict.getClassName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfSpaceElements() {
        int size;
        this.rwl.readLock().lock();
        try {
            size = this.elements.size();
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return size;
    }

    public int numberOfBlockingRead() {
        return this.statistics.getBlockingRead();
    }

    public int numberOfBlockingTake() {
        return this.statistics.getBlockingTake();
    }

    public int numberOfMissedRead() {
        return this.statistics.getMissedRead();
    }

    public int numberOfMissedTake() {
        return this.statistics.getMissedTake();
    }

    public int numberOfNumberOfListeners() {
        return this.statistics.getNumberOfListeners();
    }

    public int numberOfRead() {
        return this.statistics.getRead();
    }

    public int numberOfTake() {
        return this.statistics.getTake();
    }

    public int numberOfWrite() {
        return this.statistics.getWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SemiSpaceStatistics getStatistics() {
        SemiSpaceStatistics stats;
        this.rwl.readLock().lock();
        try {
            stats = (SemiSpaceStatistics)this.xmlToObject(this.objectToXml(this.statistics));
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return stats;
    }

    protected boolean cancelListener(ListenerHolder holder) {
        boolean success = false;
        ListenerHolder listener = this.listeners.remove(holder.getId());
        if (listener != null) {
            this.statistics.decreaseNumberOfListeners();
            success = true;
        }
        return success;
    }

    protected boolean renewListener(ListenerHolder holder, long duration) {
        boolean success = false;
        ListenerHolder listener = this.listeners.get(holder.getId());
        if (listener != null) {
            listener.setLiveUntil(duration + this.admin.calculateTime());
            success = this.listeners.get(holder.getId()) != null;
        }
        return success;
    }

    protected boolean cancelElement(Long id, boolean isTake, String className) {
        boolean success = false;
        Holder elem = this.elements.removeHolderById(id, className);
        if (elem != null) {
            if (elem.getId() != id.longValue()) {
                throw new RuntimeException("Sanity problem. Removed " + id + " and got back element with id " + elem.getId());
            }
            success = true;
            SemiEvent semiEvent = null;
            semiEvent = isTake ? new SemiTakenEvent(elem.getId()) : new SemiExpirationEvent(elem.getId());
            this.notifyListeners(new EventDistributor(elem.getClassName(), semiEvent, elem.getSearchMap()));
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renewElement(Holder holder, long duration) {
        boolean success = false;
        this.rwl.writeLock().lock();
        try {
            Holder elem = this.elements.findById(holder.getId(), holder.getClassName());
            if (elem != null) {
                elem.setLiveUntil(duration + this.admin.calculateTime());
                success = true;
                this.notifyListeners(new EventDistributor(elem.getClassName(), new SemiRenewalEvent(elem.getId(), elem.getLiveUntil()), elem.getSearchMap()));
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] findAllHolderIds() {
        Long[] result = null;
        this.rwl.readLock().lock();
        try {
            result = this.elements.findAllHolderIds();
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return result;
    }

    protected class WrappedInternalWriter
    implements Runnable {
        private Object entry;
        private long leaseTimeMs;
        private Exception exception;
        private SemiLease lease;

        public Exception getException() {
            return this.exception;
        }

        public SemiLease getLease() {
            return this.lease;
        }

        public WrappedInternalWriter(Object entry, long leaseTimeMs) {
            this.entry = entry;
            this.leaseTimeMs = leaseTimeMs;
        }

        public void run() {
            try {
                this.lease = SemiSpace.this.writeInternally(this.entry, this.leaseTimeMs);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

