/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.actor;

import java.util.ArrayList;
import java.util.List;
import org.semispace.NameValueQuery;
import org.semispace.SemiEventRegistration;
import org.semispace.SemiLease;
import org.semispace.SemiSpaceInterface;
import org.semispace.actor.ActorManifest;
import org.semispace.actor.ActorMessage;
import org.semispace.actor.ActorNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Actor {
    private static final Logger log = LoggerFactory.getLogger(Actor.class);
    private static final long FOREVER = 1827387392L;
    private final List<SemiEventRegistration> notifications = new ArrayList<SemiEventRegistration>();
    private SemiSpaceInterface space;
    private Long actorId;
    private long defaultLifeMsOfSpaceObject = 1000L;

    public long getDefaultLifeMsOfSpaceObject() {
        return this.defaultLifeMsOfSpaceObject;
    }

    public void setDefaultLifeMsOfSpaceObject(long defaultLifeMsOfSpaceObject) {
        this.defaultLifeMsOfSpaceObject = defaultLifeMsOfSpaceObject;
    }

    public final void register(SemiSpaceInterface registerWith) {
        this.register(registerWith, 1827387392L);
    }

    public final void register(SemiSpaceInterface registerWith, long actorLifeMs) {
        SemiEventRegistration registration;
        this.space = registerWith;
        NameValueQuery nvq = new NameValueQuery();
        nvq.name = "internal";
        nvq.value = "disregard";
        SemiLease lease = this.space.write(nvq, 50L);
        this.actorId = lease.getHolderId();
        lease.cancel();
        ActorNotification an = null;
        for (Object toTake : this.getTakeTemplates()) {
            an = new ActorNotification(this, this.space, toTake, true);
            registration = this.space.notify(toTake, an, actorLifeMs);
            if (registration == null) {
                throw new RuntimeException("Did not manage to register with space.");
            }
            this.notifications.add(registration);
        }
        for (Object toRead : this.getReadTemplates()) {
            an = new ActorNotification(this, this.space, toRead, false);
            registration = this.space.notify(toRead, an, actorLifeMs);
            if (registration == null) {
                throw new RuntimeException("Did not manage to register with space.");
            }
            this.notifications.add(registration);
        }
        ActorMessage template = new ActorMessage();
        template.setAddress(this.actorId);
        an = new ActorNotification(this, this.space, template, true);
        this.notifications.add(this.space.notify(template, an, actorLifeMs));
        log.debug("Registered actor (" + this.getClass().getName() + ") with id " + this.actorId + " and this object registered " + this.notifications.size() + " notification element(s).");
    }

    public void unregister() {
        for (SemiEventRegistration registration : this.notifications) {
            registration.getLease().cancel();
        }
        this.notifications.clear();
        this.space = null;
        this.actorId = null;
    }

    public void send(Object obj) {
        if (this.actorId == null) {
            throw new RuntimeException("Actor id must be set. Did you remember to register actor class?");
        }
        SemiLease lease = this.space.write(obj, this.defaultLifeMsOfSpaceObject);
        ActorManifest manifest = new ActorManifest(lease.getHolderId(), this.actorId);
        this.space.write(manifest, this.defaultLifeMsOfSpaceObject);
        log.debug("Wrote manifest with holder id " + manifest.getHolderId());
    }

    public void send(Long destinationId, Object payload) {
        if (payload == null) {
            throw new RuntimeException("No parameter is allowed to be null, but payload was. Destination id was " + destinationId);
        }
        if (destinationId == null) {
            throw new RuntimeException("No parameter is allowed to be null, but destination was. Are you certain that you used originatorId when replying? Payload class: " + payload.getClass().getName());
        }
        ActorMessage msg = new ActorMessage();
        msg.setOriginatorId(this.actorId);
        msg.setAddress(destinationId);
        msg.setPayload(payload);
        this.space.write(msg, this.defaultLifeMsOfSpaceObject);
    }

    public Long getActorId() {
        return this.actorId;
    }

    public Object[] getTakeTemplates() {
        return new Object[0];
    }

    public Object[] getReadTemplates() {
        return new Object[0];
    }

    public abstract void receive(ActorMessage var1);
}

