/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.ws;

import java.util.Random;
import org.semispace.NameValueQuery;
import org.semispace.SemiSpaceInterface;
import org.semispace.ws.TokenAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFromSpaceAuthenticator
implements TokenAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(TokenFromSpaceAuthenticator.class);
    private static final long DEFAULT_SESSION_LENGTH = 1800000L;
    private SemiSpaceInterface space;

    public void setSpace(SemiSpaceInterface space) {
        this.space = space;
    }

    @Override
    public String authenticate(String username, String password) {
        NameValueQuery nvq = new NameValueQuery();
        nvq.name = "authname=" + username;
        nvq.value = password;
        NameValueQuery result = (NameValueQuery)this.space.readIfExists((Object)nvq);
        if (result != null) {
            NameValueQuery tokenQuery = new NameValueQuery();
            tokenQuery.value = "tokenFor=" + username;
            NameValueQuery existing = tokenQuery;
            while (existing != null) {
                existing = (NameValueQuery)this.space.takeIfExists((Object)tokenQuery);
            }
            String token = this.generateToken();
            tokenQuery.name = "token=" + token;
            this.space.write((Object)tokenQuery, 1800000L);
            return token;
        }
        return null;
    }

    private String generateToken() {
        Random wheel = new Random();
        String rnd = Long.toString(wheel.nextLong() & Long.MAX_VALUE, 36);
        if (rnd.length() > 7) {
            rnd = rnd.substring(0, 7);
        }
        return rnd;
    }

    @Override
    public boolean isTokenValid(String token) {
        NameValueQuery tokenQuery = new NameValueQuery();
        tokenQuery.name = "token=" + token;
        NameValueQuery spaceToken = (NameValueQuery)this.space.take((Object)tokenQuery, 200L);
        if (spaceToken != null) {
            this.space.write((Object)spaceToken, 1800000L);
            return true;
        }
        return false;
    }
}

