/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.ws;

import javax.jws.WebService;
import org.semispace.SemiSpace;
import org.semispace.ws.TokenAuthenticator;
import org.semispace.ws.TokenWsSpace;
import org.semispace.ws.WsSpaceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(endpointInterface="org.semispace.ws.TokenWsSpace")
public class TokenWsSpaceImpl
implements TokenWsSpace {
    private static final Logger log = LoggerFactory.getLogger(TokenWsSpaceImpl.class);
    private WsSpaceImpl wsspace = new WsSpaceImpl();
    private TokenAuthenticator auth;

    public void setTokenAuthenticator(TokenAuthenticator auth) {
        this.auth = auth;
    }

    public void setSpace(SemiSpace space) {
        this.wsspace.setSpace(space);
    }

    @Override
    public String login(String username, String password) {
        this.makeSureAuthIsPresent();
        return this.auth.authenticate(username, password);
    }

    private void makeSureAuthIsPresent() {
        if (this.auth == null) {
            String error = "Erroneous initizalization - need TokenAuthenticator.";
            log.error(error);
            throw new RuntimeException(error);
        }
    }

    @Override
    public String read(String token, String template, long queryLifeMs) {
        this.makeSureAuthIsOk(token);
        return this.wsspace.read(template, queryLifeMs);
    }

    private void makeSureAuthIsOk(String token) {
        this.makeSureAuthIsPresent();
        if (!this.auth.isTokenValid(token)) {
            log.warn("Space tried used with token which is not OK. Token: " + token);
            throw new RuntimeException("Token incorrect");
        }
    }

    @Override
    public String readIfExists(String token, String template) {
        this.makeSureAuthIsOk(token);
        return this.wsspace.readIfExists(template);
    }

    @Override
    public String take(String token, String template, long queryLifeMs) {
        this.makeSureAuthIsOk(token);
        return this.wsspace.take(template, queryLifeMs);
    }

    @Override
    public String takeIfExists(String token, String template) {
        this.makeSureAuthIsOk(token);
        return this.wsspace.takeIfExists(template);
    }

    @Override
    public void write(String token, String contents, long timeToLiveMs) {
        this.makeSureAuthIsOk(token);
        this.wsspace.write(contents, timeToLiveMs);
    }
}

