/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.ws;

import java.io.StringReader;
import java.util.HashMap;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilderFactory;
import org.semispace.Holder;
import org.semispace.SemiSpace;
import org.semispace.ws.WsSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@WebService(endpointInterface="org.semispace.ws.WsSpace")
public class WsSpaceImpl
implements WsSpace {
    private static final Logger log = LoggerFactory.getLogger(WsSpaceImpl.class);
    private SemiSpace space;

    public void setSpace(SemiSpace space) {
        this.space = space;
    }

    @Override
    public void write(String contents, long timeToLiveMs) {
        this.makeSureSpaceIsPresent();
        Holder elem = this.retrievePropertiesFromXml(contents);
        this.space.writeToElements(elem.getClassName(), timeToLiveMs, elem.getXml(), elem.getSearchMap());
    }

    private void makeSureSpaceIsPresent() {
        if (this.space == null) {
            String error = "Erroneous initialization - need space.";
            log.error(error);
            throw new RuntimeException(error);
        }
    }

    @Override
    public String read(String template, long queryLifeMs) {
        this.makeSureSpaceIsPresent();
        Holder elem = this.retrievePropertiesFromXml(template);
        String found = this.space.findOrWaitLeaseForTemplate(elem.getSearchMap(), queryLifeMs, false);
        return found;
    }

    @Override
    public String readIfExists(String template) {
        this.makeSureSpaceIsPresent();
        return this.read(template, 0L);
    }

    @Override
    public String take(String template, long queryLifeMs) {
        this.makeSureSpaceIsPresent();
        Holder elem = this.retrievePropertiesFromXml(template);
        String found = this.space.findOrWaitLeaseForTemplate(elem.getSearchMap(), queryLifeMs, true);
        return found;
    }

    @Override
    public String takeIfExists(String template) {
        this.makeSureSpaceIsPresent();
        return this.take(template, 0L);
    }

    protected Holder retrievePropertiesFromXml(String xmlsource) {
        InputSource is = new InputSource(new StringReader(xmlsource));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            log.error("Returning null, due to exception parsing xml: " + xmlsource, (Throwable)e);
            return null;
        }
        String doctype = doc.getDocumentElement().getNodeName();
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList children = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || node.getChildNodes().getLength() <= 0) continue;
            String name = node.getNodeName();
            String value = node.getChildNodes().item(0).getNodeValue();
            if (value == null) continue;
            map.put(name, value);
        }
        map.put("class", doctype);
        Holder holder = new Holder(xmlsource, -1L, doctype, -1L, map);
        return holder;
    }
}

