/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.NoCredentialProvidedException;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.CommandLineCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandService;

public class CommandLineCriterionProcessor {
    @NonNull
    private String connectorId;

    public CriterionTestResult process(CommandLineCriterion commandLineCriterion, TelemetryManager telemetryManager) {
        if (commandLineCriterion == null) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (String)"Malformed OSCommand criterion.");
        }
        if (commandLineCriterion.getCommandLine().isEmpty() || commandLineCriterion.getExpectedResult() == null || commandLineCriterion.getExpectedResult().isEmpty()) {
            return CriterionTestResult.success((Criterion)commandLineCriterion, (String)"CommandLine or ExpectedResult are empty. Skipping this test.");
        }
        try {
            OsCommandResult osCommandResult = OsCommandService.runOsCommand(commandLineCriterion.getCommandLine(), telemetryManager, commandLineCriterion.getTimeout(), commandLineCriterion.getExecuteLocally(), telemetryManager.getHostProperties().isLocalhost(), telemetryManager.getEmbeddedFiles(this.connectorId));
            CommandLineCriterion osCommandNoPassword = CommandLineCriterion.builder().commandLine(osCommandResult.getNoPasswordCommand()).executeLocally(commandLineCriterion.getExecuteLocally()).timeout(commandLineCriterion.getTimeout()).expectedResult(commandLineCriterion.getExpectedResult()).build();
            Matcher matcher = Pattern.compile(PslUtils.psl2JavaRegex((String)commandLineCriterion.getExpectedResult()), 10).matcher(osCommandResult.getResult());
            return matcher.find() ? CriterionTestResult.success((Criterion)osCommandNoPassword, (String)osCommandResult.getResult()) : CriterionTestResult.failure((Criterion)osCommandNoPassword, (String)osCommandResult.getResult());
        }
        catch (NoCredentialProvidedException noCredentialProvidedException) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (String)noCredentialProvidedException.getMessage());
        }
        catch (Exception exception) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (Throwable)exception);
        }
    }

    @Generated
    public CommandLineCriterionProcessor(@NonNull String connectorId) {
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.connectorId = connectorId;
    }
}

