/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.FilterResultHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandLineSourceProcessor.class);

    public SourceTable process(CommandLineSource commandLineSource, String connectorId, TelemetryManager telemetryManager) {
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        if (commandLineSource == null || commandLineSource.getCommandLine() == null || commandLineSource.getCommandLine().isEmpty()) {
            log.error("Hostname {} - Malformed OS command source.", (Object)hostname);
            return SourceTable.empty();
        }
        try {
            OsCommandResult osCommandResult = OsCommandService.runOsCommand(commandLineSource.getCommandLine(), telemetryManager, commandLineSource.getTimeout(), commandLineSource.getExecuteLocally(), telemetryManager.getHostProperties().isLocalhost(), telemetryManager.getEmbeddedFiles(connectorId));
            List resultLines = SourceTable.lineToList((String)osCommandResult.getResult(), (String)"\n");
            List filteredLines = FilterResultHelper.filterLines((List)resultLines, (Integer)commandLineSource.getBeginAtLineNumber(), (Integer)commandLineSource.getEndAtLineNumber(), (String)commandLineSource.getExclude(), (String)commandLineSource.getKeep());
            List selectedColumnsLines = FilterResultHelper.selectedColumns((List)filteredLines, (String)commandLineSource.getSeparators(), (String)commandLineSource.getSelectColumns());
            return SourceTable.builder().rawData(selectedColumnsLines.stream().collect(Collectors.joining("\n"))).table(selectedColumnsLines.stream().map(line -> Stream.of(line.split(";")).collect(Collectors.toList())).collect(Collectors.toList())).build();
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)commandLineSource.getKey(), (String)String.format("OS command: %s.", commandLineSource.getCommandLine()), (String)hostname, (Throwable)e);
            return SourceTable.empty();
        }
    }
}

