/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.ssh.SshClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class OsCommandRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsCommandRequestExecutor.class);
    private static final String SSH_FILE_MODE = "0700";
    private static final String SSH_REMOTE_DIRECTORY = "/var/tmp/";

    @WithSpan(value="SSH")
    public static String runRemoteSshCommand(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="ssh.username") @NonNull String username, char[] password, @SpanAttribute(value="ssh.key_file_path") File keyFilePath, String command, @SpanAttribute(value="ssh.timeout") long timeout, @SpanAttribute(value="ssh.local_files") List<File> localFiles, @SpanAttribute(value="ssh.command") String noPasswordCommand) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (username == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        LoggingHelper.trace(() -> log.trace("Executing Remote SSH command:\n- hostname: {}\n- username: {}\n- key-file-path: {}\n- command: {}\n- timeout: {} s\n- local-files: {}\n", new Object[]{hostname, username, keyFilePath, command, timeout, localFiles}));
        Assert.isTrue((command != null && !command.trim().isEmpty() ? 1 : 0) != 0, (String)"Command cannot be null nor empty.");
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"Timeout cannot be negative nor zero.");
        long timeoutInMilliseconds = timeout * 1000L;
        String updatedCommand = OsCommandRequestExecutor.updateCommandWithLocalList(command, localFiles);
        String noPasswordUpdatedCommand = noPasswordCommand == null ? updatedCommand : OsCommandRequestExecutor.updateCommandWithLocalList(noPasswordCommand, localFiles);
        ArrayList<String> remoteFilePaths = new ArrayList<String>();
        SshClient sshClient = null;
        try {
            sshClient = OsCommandRequestExecutor.createSshClientInstance(hostname);
            sshClient.connect((int)timeoutInMilliseconds);
            if (password == null) {
                log.warn("Hostname {} - Password could not be read. Using an empty password instead.", (Object)hostname);
            }
            OsCommandRequestExecutor.authenticateSsh(sshClient, hostname, username, password, keyFilePath);
            if (localFiles != null && !localFiles.isEmpty()) {
                for (File file : localFiles) {
                    String filename = file.getName();
                    sshClient.scp(file.getAbsolutePath(), filename, SSH_REMOTE_DIRECTORY, SSH_FILE_MODE);
                    remoteFilePaths.add(SSH_REMOTE_DIRECTORY + filename);
                }
            }
            long startTime = System.currentTimeMillis();
            SshClient.CommandResult commandResult = sshClient.executeCommand(updatedCommand, (int)timeoutInMilliseconds);
            long responseTime = System.currentTimeMillis() - startTime;
            if (!commandResult.success) {
                String message = String.format("Hostname %s - Command \"%s\" failed with result %s.", hostname, noPasswordUpdatedCommand, commandResult.result);
                log.error(message);
                throw new ClientException(message);
            }
            String result = commandResult.result;
            LoggingHelper.trace(() -> log.trace("Executed Remote SSH command:\n- Hostname: {}\n- Username: {}\n- Key-file-path: {}\n- Command: {}\n- Timeout: {} s\n- Local-files: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, username, keyFilePath, command, timeout, localFiles, result, responseTime}));
            String string = result;
            return string;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Failed to run SSH command '%s' as %s on %s.", noPasswordUpdatedCommand, username, hostname);
            log.error("Hostname {} - {}. Exception message: {}.", new Object[]{hostname, message, e.getMessage()});
            throw new ClientException(message, (Exception)e.getCause());
        }
        finally {
            OsCommandRequestExecutor.release(sshClient, remoteFilePaths, hostname, username);
        }
    }

    private static void release(SshClient sshClient, List<String> remoteFilePaths, String hostname, String username) {
        if (sshClient != null) {
            OsCommandRequestExecutor.removeCopiedRemoteFiles(sshClient, remoteFilePaths, hostname, username);
            log.debug("Hostname {} - Disconnecting SSH client.", (Object)hostname);
            sshClient.close();
        }
    }

    private static void removeCopiedRemoteFiles(SshClient sshClient, List<String> remoteFilePaths, String hostname, String username) {
        if (remoteFilePaths.isEmpty()) {
            return;
        }
        log.debug("Hostname {} - Removing remote files {}.", (Object)hostname, remoteFilePaths);
        try {
            sshClient.removeFile(remoteFilePaths.toArray(new String[remoteFilePaths.size()]));
        }
        catch (Exception e) {
            log.error("Hostname {} - Failed to remove remote files {} as {} on {}. Exception message: {}.", new Object[]{hostname, remoteFilePaths, username, hostname, e.getMessage()});
            log.debug("Hostname {} - Exception: ", (Object)hostname, (Object)e);
        }
    }

    static void authenticateSsh(SshClient sshClient, String hostname, String username, char[] password, File privateKey) throws ClientException {
        boolean authenticated;
        try {
            authenticated = privateKey != null ? sshClient.authenticate(username, privateKey, password) : (password != null && password.length > 0 ? sshClient.authenticate(username, password) : sshClient.authenticate(username));
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - Authentication as %s has failed with %s.", hostname, username, privateKey != null ? privateKey.getAbsolutePath() : null);
            log.error("Hostname {} - {}. Exception : {}.", new Object[]{hostname, message, e.getMessage()});
            throw new ClientException(message, e);
        }
        if (!authenticated) {
            String message = String.format("Hostname %s - Authentication as %s has failed with %s.", hostname, username, privateKey != null ? privateKey.getAbsolutePath() : null);
            log.error(message);
            throw new ClientException(message);
        }
    }

    static String updateCommandWithLocalList(String command, List<File> localFiles) {
        return localFiles == null || localFiles.isEmpty() ? command : localFiles.stream().reduce(command, (s, file) -> command.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)file.getAbsolutePath()), SSH_REMOTE_DIRECTORY + file.getName()), (s1, s2) -> null);
    }

    public static SshClient createSshClientInstance(String hostname) {
        return new SshClient(hostname, StandardCharsets.UTF_8);
    }

    @Generated
    private OsCommandRequestExecutor() {
    }
}

