/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc;

import javax.inject.Inject;
import org.sevensource.commons.configuration.jdbc.database.ExtendedCompositeConfiguration;
import org.springframework.core.env.Environment;

public abstract class AbstractConfiguration<T> {
    private final Environment env;
    private final ExtendedCompositeConfiguration databaseConfiguration;
    private T deploymentEnvironment;
    private String serverName;
    private String applicationName;

    @Inject
    public AbstractConfiguration(Environment environment, ExtendedCompositeConfiguration databaseConfiguration) {
        this.env = environment;
        this.databaseConfiguration = databaseConfiguration;
    }

    public T getDeploymentEnvironment() {
        if (this.deploymentEnvironment == null) {
            this.deploymentEnvironment = this.resolveConfigurationEnvironment();
        }
        return this.deploymentEnvironment;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public ExtendedCompositeConfiguration getConfig() {
        return this.databaseConfiguration;
    }

    protected Environment getEnvironment() {
        return this.env;
    }

    protected abstract T resolveConfigurationEnvironment();
}

