/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc.database;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.configuration.DatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDatabaseConfiguration
extends DatabaseConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CachingDatabaseConfiguration.class);
    private ConcurrentMap<String, Object> databaseConfigurationCache = new ConcurrentHashMap<String, Object>();

    public CachingDatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name, boolean commits) {
        super(datasource, table, nameColumn, keyColumn, valueColumn, name, commits);
    }

    public Object getProperty(String key) {
        if (!this.databaseConfigurationCache.containsKey(key)) {
            Object property = super.getProperty(key);
            this.databaseConfigurationCache.put(key, property);
        }
        return this.databaseConfigurationCache.get(key);
    }

    protected void addPropertyDirect(String key, Object obj) {
        super.addPropertyDirect(key, obj);
        this.databaseConfigurationCache.remove(key);
    }

    public void addProperty(String key, Object value) {
        super.addProperty(key, value);
        this.databaseConfigurationCache.remove(key);
    }

    protected void clearPropertyDirect(String key) {
        super.clearPropertyDirect(key);
        this.databaseConfigurationCache.remove(key);
    }

    public void clear() {
        super.clear();
        this.databaseConfigurationCache.clear();
    }

    public void clearCache() {
        this.databaseConfigurationCache.clear();
    }
}

