/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc.database;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.NotImplementedException;
import org.sevensource.commons.configuration.jdbc.database.CachingDatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedCompositeConfiguration
extends CompositeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedCompositeConfiguration.class);
    private Configuration serverConfiguration;
    private Configuration defaultConfiguration;

    public void setServerConfiguration(Configuration configuration) {
        this.serverConfiguration = configuration;
        this.addConfiguration(configuration);
    }

    public void setDefaultConfiguration(Configuration configuration) {
        this.defaultConfiguration = configuration;
        this.addConfiguration(configuration);
    }

    public Configuration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void addProperty(String key, Object value) {
        if (logger.isWarnEnabled()) {
            logger.warn("Adding property with [{}]=[{}] to IN-MEMORY configuration - NOT PERSISTENT!", (Object)key, value);
        }
        super.addProperty(key, value);
    }

    public void setProperty(String key, Object value) {
        logger.error("Adding properties on the *CompositeConfiguration* is disabled, since it also clears the values of the underlying database configurations");
        throw new NotImplementedException("Adding properties is disabled, since it also clears the values of the underlying database configurations");
    }

    public void clearCache() {
        if (this.getDefaultConfiguration() instanceof CachingDatabaseConfiguration) {
            ((CachingDatabaseConfiguration)this.getDefaultConfiguration()).clearCache();
        }
        if (this.getServerConfiguration() instanceof CachingDatabaseConfiguration) {
            ((CachingDatabaseConfiguration)this.getServerConfiguration()).clearCache();
        }
    }
}

