/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc.database;

import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.event.EventSource;
import org.sevensource.commons.configuration.jdbc.database.CachingDatabaseConfiguration;
import org.sevensource.commons.configuration.jdbc.database.ExtendedCompositeConfiguration;
import org.sevensource.commons.configuration.jdbc.database.ExtendedDatabaseConfigurationListener;

public class ExtendedDatabaseConfigurationFactory {
    private String table;
    private String nameColumn;
    private String keyColumn;
    private String valueColumn;
    private String defaultsIdentifier;
    private final DataSource dataSource;
    private final String serverName;
    private final String applicationName;

    public ExtendedDatabaseConfigurationFactory(DataSource dataSource, String serverName, String applicationName) {
        this.dataSource = dataSource;
        this.serverName = serverName;
        this.applicationName = applicationName;
    }

    public ExtendedCompositeConfiguration buildConfiguration() {
        Configuration serverConfiguration = this.buildDatabaseConfiguration(this.getServerName());
        Configuration defaultConfiguration = this.buildDatabaseConfiguration(this.getDefaultsIdentifier());
        ExtendedCompositeConfiguration config = new ExtendedCompositeConfiguration();
        this.addListeners((EventSource)config);
        config.setServerConfiguration(serverConfiguration);
        config.setDefaultConfiguration(defaultConfiguration);
        return config;
    }

    private Configuration buildDatabaseConfiguration(String subset) {
        CachingDatabaseConfiguration config = new CachingDatabaseConfiguration(this.getDataSource(), this.getTable(), this.getNameColumn(), this.getKeyColumn(), this.getValueColumn(), this.getApplicationName(), false);
        this.addListeners((EventSource)config);
        return config.subset(subset);
    }

    private void addListeners(EventSource config) {
        ExtendedDatabaseConfigurationListener listener = new ExtendedDatabaseConfigurationListener();
        config.addConfigurationListener((ConfigurationListener)listener);
        config.addErrorListener((ConfigurationErrorListener)listener);
    }

    private DataSource getDataSource() {
        return this.dataSource;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getNameColumn() {
        return this.nameColumn;
    }

    public void setNameColumn(String nameColumn) {
        this.nameColumn = nameColumn;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public void setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
    }

    public String getDefaultsIdentifier() {
        return this.defaultsIdentifier;
    }

    public void setDefaultsIdentifier(String defaultsIdentifier) {
        this.defaultsIdentifier = defaultsIdentifier;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

