/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc.database;

import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedDatabaseConfigurationListener
implements ConfigurationListener,
ConfigurationErrorListener {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedDatabaseConfigurationListener.class);

    public void configurationError(ConfigurationErrorEvent event) {
        logger.error("Configuration error for property [{}] with eventType [{}].", (Object)event.getPropertyName(), (Object)event.getType());
    }

    public void configurationChanged(ConfigurationEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.isBeforeUpdate() || !logger.isInfoEnabled()) break;
                logger.info("Property [{}]=[{}] added to configuration.", (Object)event.getPropertyName(), event.getPropertyValue());
                break;
            }
            case 3: {
                if (!event.isBeforeUpdate()) {
                    if (!logger.isInfoEnabled()) break;
                    logger.info("Property [{}] set to new value [{}].", (Object)event.getPropertyName(), event.getPropertyValue());
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug("Going to set property [{}] to new value [{}].", (Object)event.getPropertyName(), event.getPropertyValue());
                break;
            }
            case 4: {
                if (event.isBeforeUpdate() || !logger.isInfoEnabled()) break;
                logger.info("Configuration has been cleared");
                break;
            }
            case 2: {
                if (event.isBeforeUpdate() || !logger.isInfoEnabled()) break;
                logger.info("Property [{}] has been cleared", (Object)event.getPropertyName());
                break;
            }
            case 5: {
                if (!logger.isDebugEnabled()) break;
                logger.debug("Property [{}] with value [{}] has been read.", (Object)event.getPropertyName(), event.getPropertyValue());
                break;
            }
            default: {
                if (!logger.isWarnEnabled()) break;
                logger.warn("Unknown ConfigurationChange Event with type-id [{}]", (Object)event.getType());
            }
        }
    }
}

