/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc.impl;

import org.apache.commons.lang.StringUtils;
import org.sevensource.commons.configuration.jdbc.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public enum DefaultEnvironment {
    DEVEL,
    TEST,
    PROD;

    private static final Logger logger;

    public static DefaultEnvironment resolveEnvironment(Environment env) {
        String environment = env.getProperty("config.environment");
        if (!org.springframework.util.StringUtils.hasText((String)environment)) {
            String msg = String.format("No deployment environment. Please specify one of the following environments: %s", StringUtils.join((Object[])DefaultEnvironment.values(), (String)", "));
            logger.error(msg);
            throw new ConfigurationException(msg);
        }
        try {
            return DefaultEnvironment.valueOf(environment);
        }
        catch (Exception e) {
            String msg = String.format("Illegal deployment environment found [%s]. Please specify one of the following environments: %s", environment, StringUtils.join((Object[])DefaultEnvironment.values(), (String)", "));
            logger.error(msg);
            throw new ConfigurationException(msg, e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(DefaultEnvironment.class);
    }
}

