/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc.impl.spring;

import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.sevensource.commons.configuration.jdbc.AbstractConfiguration;
import org.sevensource.commons.configuration.jdbc.ConfigurationException;
import org.sevensource.commons.configuration.jdbc.database.ExtendedCompositeConfiguration;
import org.sevensource.commons.configuration.jdbc.database.ExtendedDatabaseConfigurationFactory;
import org.sevensource.commons.configuration.jdbc.impl.DefaultConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public abstract class AbstractDefaultConfigConfiguration<T extends DefaultConfiguration> {
    public static final String CONFIGURATIONS_DATASOURCE_NAME = "configurationsDataSource";

    @Bean(name={"compositeDatabaseConfiguration"})
    @Inject
    public ExtendedCompositeConfiguration compositeDatabaseConfiguration(Environment env) {
        DataSource dataSource = this.getDataSource();
        ExtendedDatabaseConfigurationFactory factory = this.databaseConfigurationFactory(dataSource, env);
        return factory.buildConfiguration();
    }

    @Bean(name={"configuration"})
    @Inject
    public T configuration(Environment env, ExtendedCompositeConfiguration compositeDatabaseConfiguration) {
        T configuration = this.getConfigurationInstance(env, compositeDatabaseConfiguration);
        ((AbstractConfiguration)configuration).setServerName(this.resolveServerName(env));
        ((AbstractConfiguration)configuration).setApplicationName(this.resolveApplicationName(env));
        return configuration;
    }

    protected String resolveServerName(Environment env) {
        String name = env.getProperty("config.serverName");
        if (StringUtils.isBlank((String)name)) {
            String msg = String.format("Please specify a servername (Parameter [%s])", "config.serverName");
            throw new ConfigurationException(msg);
        }
        return name;
    }

    protected String resolveApplicationName(Environment env) {
        String name = env.getProperty("config.applicationName");
        if (StringUtils.isBlank((String)name)) {
            String msg = String.format("Please specify a applicationname (Parameter [%s])", "config.applicationName");
            throw new ConfigurationException(msg);
        }
        return name;
    }

    protected abstract DataSource getDataSource();

    protected abstract T getConfigurationInstance(Environment var1, ExtendedCompositeConfiguration var2);

    protected abstract ExtendedDatabaseConfigurationFactory databaseConfigurationFactory(DataSource var1, Environment var2);
}

