/*
 * Decompiled with CFR 0.152.
 */
package org.sevensource.commons.configuration.jdbc.impl.spring;

import javax.mail.Session;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.sevensource.commons.configuration.jdbc.impl.DefaultEnvironment;
import org.sevensource.commons.configuration.jdbc.spring.support.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.jndi.JndiObjectFactoryBean;

public class DefaultConfigurationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfigurationContextInitializer.class);
    private static final String APPLICATION_CONTEXT_PROVIDER_BEAN_NAME = ApplicationContextProvider.class.getSimpleName();

    public void initialize(final ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        DefaultEnvironment profileEnvironment = DefaultEnvironment.resolveEnvironment((Environment)env);
        if (logger.isInfoEnabled()) {
            logger.info("Adding {} to active Spring profiles", (Object)profileEnvironment.name());
        }
        env.addActiveProfile(profileEnvironment.name());
        applicationContext.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                if (!beanFactory.containsBeanDefinition(APPLICATION_CONTEXT_PROVIDER_BEAN_NAME)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Registering {} to statically access the Spring Context", (Object)ApplicationContextProvider.class.getName());
                    }
                    ApplicationContextProvider contextProvider = new ApplicationContextProvider();
                    contextProvider.setApplicationContext((ApplicationContext)applicationContext);
                    beanFactory.registerSingleton(APPLICATION_CONTEXT_PROVIDER_BEAN_NAME, (Object)contextProvider);
                }
            }
        });
        applicationContext.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                if (JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable()) {
                    if (logger.isInfoEnabled()) {
                        logger.info("JNDI is available. Proceeding with JNDI lookups");
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Registering mailSession in BeanFactoryPostProcessor");
                    }
                    String jndiName = "mail/Session";
                    try {
                        JndiObjectFactoryBean mailFactory = new JndiObjectFactoryBean();
                        mailFactory.setCache(true);
                        mailFactory.setResourceRef(true);
                        mailFactory.setExpectedType(Session.class);
                        mailFactory.setJndiName("mail/Session");
                        mailFactory.afterPropertiesSet();
                        beanFactory.registerSingleton("mailSession", (Object)mailFactory);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error("Error looking up JNDI MailSession", (Throwable)e);
                    }
                    catch (NameNotFoundException nfe) {
                        logger.warn("No MailSession registered in JNDI under name [{}]. Skipping mail registration", (Object)"mail/Session");
                    }
                    catch (NamingException e) {
                        logger.error("JNDI Error", (Throwable)e);
                    }
                }
            }
        });
    }
}

