/**
 * The root package of Shakespeare contains all classes needed to implement the basic Screenplay
 * concepts:
 *
 * <ul>
 *   <li>{@link org.shakespeareframework.Actor},
 *   <li>{@link org.shakespeareframework.Ability},
 *   <li>{@link org.shakespeareframework.Task}, and
 *   <li>{@link org.shakespeareframework.Question}.
 * </ul>
 *
 * <p>It also contains Shakespeare's extensions to the basic Screenplay:
 *
 * <ul>
 *   <li>{@link org.shakespeareframework.Retryable}, {@link org.shakespeareframework.RetryableTask}
 *       and {@link org.shakespeareframework.RetryableQuestion}, and
 *   <li>{@link org.shakespeareframework.Fact}.
 * </ul>
 *
 * @see <a href="https://shakespeareframework.org/latest/manual/#_actors_with_abilities">Manual on
 *     "Actors with Abilities"</a>
 * @see <a href="https://shakespeareframework.org/latest/manual/#_doing_tasks">Manual on "Doing
 *     Tasks"</a>
 * @see <a href="https://shakespeareframework.org/latest/manual/#_checking_questions">Manual on
 *     "Checking Questions"</a>
 * @see <a href="https://shakespeareframework.org/latest/manual/#_retryables">Manual on
 *     "Retryables"</a>
 * @see <a href="https://shakespeareframework.org/latest/manual/#_learning_remembering_facts">Manual
 *     on "Remembering Facts"</a>
 */
package org.shakespeareframework;
