/*
 * Decompiled with CFR 0.152.
 */
package org.shakespeareframework.selenium;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.shakespeareframework.selenium.BrowserType;
import org.shakespeareframework.selenium.WebDriverSupplier;

public class WebDriverManagerWebDriverSupplier
extends WebDriverSupplier {
    private final WebDriverManager webDriverManager;
    private WebDriver webDriver;

    public WebDriverManagerWebDriverSupplier(WebDriverManager webDriverManager, BrowserType browserType, Capabilities additionalCapabilities) {
        super(browserType, additionalCapabilities);
        this.webDriverManager = webDriverManager;
    }

    public WebDriverManagerWebDriverSupplier(WebDriverManager webDriverManager, BrowserType browserType) {
        this(webDriverManager, browserType, null);
    }

    @Override
    public WebDriver get() {
        if (this.webDriver == null) {
            this.webDriver = Objects.requireNonNull(this.webDriverManager.capabilities(this.getCapabilities()).create(), "Creating the WebDriver failed");
        }
        return this.webDriver;
    }

    @Override
    public void close() {
        this.webDriverManager.quit();
        this.webDriver = null;
    }
}

