/*
 * Decompiled with CFR 0.152.
 */
package org.shakespeareframework.selenium;

import java.util.function.Supplier;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.shakespeareframework.selenium.BrowserType;

public abstract class WebDriverSupplier
implements Supplier<WebDriver>,
AutoCloseable {
    private final BrowserType browserType;
    private final Capabilities capabilities;

    protected WebDriverSupplier(BrowserType browserType, Capabilities additionalCapabilities) {
        this.browserType = browserType;
        this.capabilities = additionalCapabilities == null ? browserType.getBaseCapabilities() : browserType.getBaseCapabilities().merge(additionalCapabilities);
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public String toString() {
        return this.browserType.name();
    }
}

