/*
 * Decompiled with CFR 0.152.
 */
package org.shakespeareframework.selenium;

import java.util.Objects;
import org.openqa.selenium.WebDriver;
import org.shakespeareframework.Ability;
import org.shakespeareframework.selenium.WebDriverSupplier;

public final class BrowseTheWeb
implements Ability,
AutoCloseable {
    private final WebDriverSupplier webDriverSupplier;
    private final String baseUrl;

    public BrowseTheWeb(WebDriverSupplier webDriverSupplier, String baseUrl) {
        this.webDriverSupplier = Objects.requireNonNull(webDriverSupplier);
        this.baseUrl = baseUrl;
    }

    public BrowseTheWeb(WebDriverSupplier webDriverSupplier) {
        this(webDriverSupplier, null);
    }

    public WebDriver getWebDriver() {
        WebDriver webDriver = (WebDriver)this.webDriverSupplier.get();
        if (this.baseUrl != null && !webDriver.getCurrentUrl().startsWith("http")) {
            webDriver.get(this.baseUrl);
        }
        return webDriver;
    }

    @Override
    public void close() throws Exception {
        this.webDriverSupplier.close();
    }

    public String toString() {
        return String.format("browse the web using %s", this.webDriverSupplier);
    }
}

