/*
 * Decompiled with CFR 0.152.
 */
package org.shakespeareframework.selenium;

import java.util.Arrays;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.shakespeareframework.selenium.UnsupportedBrowserTypeException;

public enum BrowserType {
    CHROME(ChromeDriver.class, (Capabilities)new ChromeOptions()),
    FIREFOX(FirefoxDriver.class, (Capabilities)new FirefoxOptions()),
    EDGE(EdgeDriver.class, (Capabilities)new EdgeOptions()),
    IEXPLORER(InternetExplorerDriver.class, (Capabilities)new InternetExplorerOptions()),
    SAFARI(SafariDriver.class, (Capabilities)new SafariOptions());

    private final Class<? extends WebDriver> webDriverClass;
    private final ImmutableCapabilities baseCapabilities;

    private BrowserType(Class<? extends WebDriver> webDriverClass, Capabilities baseCapabilities) {
        this.webDriverClass = webDriverClass;
        this.baseCapabilities = ImmutableCapabilities.copyOf((Capabilities)baseCapabilities);
    }

    public static BrowserType forName(String string) {
        return Arrays.stream(BrowserType.values()).filter(browserType -> browserType.name().equalsIgnoreCase(string)).findAny().orElseThrow(() -> new UnsupportedBrowserTypeException(string));
    }

    public Class<? extends WebDriver> getWebDriverClass() {
        return this.webDriverClass;
    }

    public Capabilities getBaseCapabilities() {
        return this.baseCapabilities;
    }
}

