/*
 * Decompiled with CFR 0.152.
 */
package org.shakespeareframework.selenium;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.openqa.selenium.WebDriver;
import org.shakespeareframework.Actor;
import org.shakespeareframework.Question;
import org.shakespeareframework.RetryableQuestion;
import org.shakespeareframework.RetryableTask;
import org.shakespeareframework.Task;
import org.shakespeareframework.reporting.FileReporter;
import org.shakespeareframework.selenium.BrowseTheWeb;

public class HtmlSnapshotReporter
extends FileReporter {
    private final boolean reportSuccess;

    public HtmlSnapshotReporter(Path reportsPath, boolean reportSuccess) {
        super(reportsPath);
        this.reportSuccess = reportSuccess;
    }

    public HtmlSnapshotReporter(Path reportsPath) {
        this(reportsPath, false);
    }

    public void retry(Actor actor, RetryableTask task, Exception cause) {
        this.takeHtmlSnapshot(actor, FileReporter.ReportType.RETRY, task);
    }

    public void success(Actor actor, Task task) {
        if (this.reportSuccess) {
            this.takeHtmlSnapshot(actor, FileReporter.ReportType.SUCCESS, task);
        }
    }

    public void failure(Actor actor, Task task, Exception cause) {
        this.takeHtmlSnapshot(actor, FileReporter.ReportType.FAILURE, task);
    }

    public void retry(Actor actor, RetryableQuestion<?> question, Exception cause) {
        this.takeHtmlSnapshot(actor, FileReporter.ReportType.RETRY, question);
    }

    public <A> void retry(Actor actor, RetryableQuestion<A> question, A answer) {
        this.takeHtmlSnapshot(actor, FileReporter.ReportType.RETRY, question);
    }

    public <A> void success(Actor actor, Question<A> question, A answer) {
        if (this.reportSuccess) {
            this.takeHtmlSnapshot(actor, FileReporter.ReportType.SUCCESS, question);
        }
    }

    public void failure(Actor actor, Question<?> question, Exception cause) {
        this.takeHtmlSnapshot(actor, FileReporter.ReportType.FAILURE, question);
    }

    public <A> void failure(Actor actor, Question<A> question, A answer) {
        this.takeHtmlSnapshot(actor, FileReporter.ReportType.FAILURE, question);
    }

    private void takeHtmlSnapshot(Actor actor, FileReporter.ReportType reportType, Object activity) {
        WebDriver webDriver = ((BrowseTheWeb)actor.uses(BrowseTheWeb.class)).getWebDriver();
        this.writeReport(actor, reportType, activity, "html", webDriver.getPageSource().getBytes(StandardCharsets.UTF_8));
    }
}

