/*
 * Decompiled with CFR 0.152.
 */
package org.shakespeareframework.selenium;

import java.nio.file.Path;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.shakespeareframework.Actor;
import org.shakespeareframework.Question;
import org.shakespeareframework.RetryableQuestion;
import org.shakespeareframework.RetryableTask;
import org.shakespeareframework.Task;
import org.shakespeareframework.reporting.FileReporter;
import org.shakespeareframework.selenium.BrowseTheWeb;

public class ScreenshotReporter
extends FileReporter {
    private final boolean reportSuccess;

    public ScreenshotReporter(Path reportsPath, boolean reportSuccess) {
        super(reportsPath);
        this.reportSuccess = reportSuccess;
    }

    public ScreenshotReporter(Path reportsPath) {
        this(reportsPath, false);
    }

    public void retry(Actor actor, RetryableTask task, Exception cause) {
        this.takeScreenshot(actor, FileReporter.ReportType.RETRY, task);
    }

    public void success(Actor actor, Task task) {
        if (this.reportSuccess) {
            this.takeScreenshot(actor, FileReporter.ReportType.SUCCESS, task);
        }
    }

    public void failure(Actor actor, Task task, Exception cause) {
        this.takeScreenshot(actor, FileReporter.ReportType.FAILURE, task);
    }

    public void retry(Actor actor, RetryableQuestion<?> question, Exception cause) {
        this.takeScreenshot(actor, FileReporter.ReportType.RETRY, question);
    }

    public <A> void retry(Actor actor, RetryableQuestion<A> question, A answer) {
        this.takeScreenshot(actor, FileReporter.ReportType.RETRY, question);
    }

    public <A> void success(Actor actor, Question<A> question, A answer) {
        if (this.reportSuccess) {
            this.takeScreenshot(actor, FileReporter.ReportType.SUCCESS, question);
        }
    }

    public void failure(Actor actor, Question<?> question, Exception cause) {
        this.takeScreenshot(actor, FileReporter.ReportType.FAILURE, question);
    }

    public <A> void failure(Actor actor, Question<A> question, A answer) {
        this.takeScreenshot(actor, FileReporter.ReportType.FAILURE, question);
    }

    private void takeScreenshot(Actor actor, FileReporter.ReportType reportType, Object activity) {
        TakesScreenshot takesScreenshot = (TakesScreenshot)((BrowseTheWeb)actor.uses(BrowseTheWeb.class)).getWebDriver();
        this.writeReport(actor, reportType, activity, "png", (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES));
    }
}

