/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.sheinbergon.needle.AffinityResolver;
import org.sheinbergon.needle.util.AffinityDescriptorException;

public class AffinityDescriptor {
    @VisibleForTesting
    static final int AVAILABLE_CORES = Runtime.getRuntime().availableProcessors();
    @VisibleForTesting
    static final int MASK_UPPER_BOUND = (int)Math.pow(2.0, AVAILABLE_CORES);
    @VisibleForTesting
    static final String SPECIFICATION_DELIMITER = ",";
    @VisibleForTesting
    static final String RANGE_DELIMITER = "-";
    @VisibleForTesting
    static final AffinityDescriptor UNSUPPORTED = new AffinityDescriptor(new Specification[0]){

        @Override
        public long mask() {
            return NumberUtils.LONG_MINUS_ONE;
        }

        @Override
        public String toString() {
            return null;
        }
    };
    private static final Pattern RANGE = Pattern.compile("^\\s*(\\d{1,3})\\s*-\\s*(\\d{1,3})\\s*$");
    private static final Pattern SINGLE = Pattern.compile("^\\s*(\\d{1,3})\\s*$");
    @Nonnull
    private final Set<Specification> specifications;
    private final AtomicReference<Object> mask = new AtomicReference();

    AffinityDescriptor(Specification ... affinitySpecifications) {
        this.specifications = Set.of(affinitySpecifications);
    }

    static AffinityDescriptor process() {
        return AffinityResolver.instance.process();
    }

    public static AffinityDescriptor from(long mask) {
        HashSet<Specification> specifications = new HashSet<Specification>();
        Integer start = null;
        Integer end = null;
        for (int core = 0; core < 64; ++core) {
            if ((1L << core & mask) > 0L) {
                if (start == null) {
                    start = core;
                }
                end = core;
                continue;
            }
            if (start == null || end == null) continue;
            specifications.add(Specification.from(start, end));
            start = null;
            end = null;
        }
        return AffinityDescriptor.from(specifications);
    }

    public static AffinityDescriptor from(@Nonnull String mask) {
        Set<Specification> specifications = Arrays.stream(StringUtils.split(mask, SPECIFICATION_DELIMITER)).filter(Predicate.not(String::isBlank)).map(AffinityDescriptor::specificationFrom).collect(Collectors.toSet());
        return AffinityDescriptor.from(specifications);
    }

    private static AffinityDescriptor from(@Nonnull Set<Specification> specifications) {
        if (specifications.isEmpty()) {
            return AffinityDescriptor.process();
        }
        AffinityDescriptor descriptor = new AffinityDescriptor((Specification[])specifications.toArray(Specification[]::new));
        AffinityDescriptor.validate(descriptor.mask());
        return descriptor;
    }

    private static Specification specificationFrom(@Nonnull String specification) {
        int end;
        int start;
        Matcher matcher = RANGE.matcher(specification);
        if (matcher.matches()) {
            start = Integer.parseInt(matcher.group(1));
            end = Integer.parseInt(matcher.group(2));
        } else {
            matcher = SINGLE.matcher(specification);
            if (matcher.matches()) {
                start = end = Integer.parseInt(matcher.group());
            } else {
                throw new AffinityDescriptorException(String.format("Illegal specification - '%s'", specification));
            }
        }
        return Specification.from(start, end);
    }

    private static void validate(long mask) {
        if (mask <= 0L || mask > (long)MASK_UPPER_BOUND) {
            throw new AffinityDescriptorException(String.format("Mask %d is out of bounds, only %d cores are available", mask, AVAILABLE_CORES));
        }
    }

    public String toString() {
        return this.specifications.stream().map(Object::toString).sorted().collect(Collectors.joining(SPECIFICATION_DELIMITER));
    }

    public final int hashCode() {
        return Objects.hashCode(this.mask());
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof AffinityDescriptor)) {
            return false;
        }
        return ((AffinityDescriptor)other).mask() == this.mask();
    }

    private long computeMask() {
        return Optional.ofNullable(this.specifications).map(Collection::stream).map(stream -> stream.map(Specification::mask)).flatMap(stream -> stream.reduce((m1, m22) -> m1 | m22)).orElse(NumberUtils.LONG_ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long mask() {
        Object value = this.mask.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.mask;
            synchronized (atomicReference) {
                value = this.mask.get();
                if (value == null) {
                    long actualValue = this.computeMask();
                    value = actualValue;
                    this.mask.set(value);
                }
            }
        }
        return (Long)value;
    }

    private static interface Specification {
        private static Specification from(int start, int end) {
            int diff = end - start;
            if (diff > 0) {
                return new Range(start, end);
            }
            if (diff == 0) {
                return new Single(end);
            }
            throw new AffinityDescriptorException(String.format("Invalid core range, starts at %d, ends at %d", start, end));
        }

        public long mask();

        public static class Range
        implements Specification {
            private final int start;
            private final int end;
            private final AtomicReference<Object> mask = new AtomicReference();

            private long computeMask() {
                return IntStream.rangeClosed(this.start, this.end).map(core -> 1 << core).reduce((c1, c2) -> c1 | c2).orElseThrow(() -> new IllegalArgumentException("Illegal range specified"));
            }

            public String toString() {
                return String.format("%d%s%d", this.start, AffinityDescriptor.RANGE_DELIMITER, this.end);
            }

            public Range(int start, int end) {
                this.start = start;
                this.end = end;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long mask() {
                Object value = this.mask.get();
                if (value == null) {
                    AtomicReference<Object> atomicReference = this.mask;
                    synchronized (atomicReference) {
                        value = this.mask.get();
                        if (value == null) {
                            long actualValue = this.computeMask();
                            value = actualValue;
                            this.mask.set(value);
                        }
                    }
                }
                return (Long)value;
            }
        }

        public static class Single
        implements Specification {
            private final int core;

            @Override
            public long mask() {
                return 1 << this.core;
            }

            public String toString() {
                return Integer.toString(this.core);
            }

            public Single(int core) {
                this.core = core;
            }
        }
    }
}

