/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jna.Platform;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;
import org.sheinbergon.needle.AffinityDescriptor;
import org.sheinbergon.needle.jna.linux.LinuxAffinityResolver;
import org.sheinbergon.needle.jna.win32.Win32AffinityResolver;

public abstract class AffinityResolver<I> {
    static final AffinityResolver instance = Platform.isWindows() ? Win32AffinityResolver.INSTANCE : (Platform.isLinux() ? LinuxAffinityResolver.INSTANCE : NoOp.INSTANCE);

    @Nonnull
    protected abstract I self();

    final void thread(@Nonnull AffinityDescriptor affinity) {
        this.thread(this.self(), affinity);
    }

    protected abstract void thread(@Nonnull I var1, @Nonnull AffinityDescriptor var2);

    @Nonnull
    final AffinityDescriptor thread() {
        return this.thread(this.self());
    }

    @Nonnull
    protected abstract AffinityDescriptor process();

    @Nonnull
    protected abstract AffinityDescriptor thread(@Nonnull I var1);

    static final class NoOp
    extends AffinityResolver<Object> {
        @VisibleForTesting
        static final AffinityResolver<?> INSTANCE = new NoOp();

        @Override
        @Nonnull
        protected Object self() {
            return NumberUtils.LONG_MINUS_ONE;
        }

        @Override
        @Nonnull
        protected AffinityDescriptor process() {
            return AffinityDescriptor.UNSUPPORTED;
        }

        @Override
        protected void thread(@Nonnull Object identifier, @Nonnull AffinityDescriptor affinity) {
        }

        @Override
        @Nonnull
        protected AffinityDescriptor thread(@Nonnull Object identifier) {
            return AffinityDescriptor.UNSUPPORTED;
        }

        private NoOp() {
        }
    }
}

