/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sheinbergon.needle.AffinityDescriptor;
import org.sheinbergon.needle.Needle;
import org.sheinbergon.needle.util.NeedleException;

public interface Pinned {
    @Nonnull
    public static Optional<Pinned> current() {
        return Optional.of(Thread.currentThread()).filter(Pinned.class::isInstance).map(Pinned.class::cast);
    }

    public Object nativeId();

    public AffinityDescriptor affinity();

    public void affinity(@Nonnull AffinityDescriptor var1);

    public static final class Delegate
    implements Pinned {
        private volatile Object nativeId = null;
        @Nullable
        private Initializer initializer = null;

        @Override
        public AffinityDescriptor affinity() {
            this.ensureInitialization();
            return Needle.affinity(this.nativeId);
        }

        @Override
        public void affinity(@Nonnull AffinityDescriptor affinityDescriptor) {
            this.ensureInitialization();
            Needle.affinity(affinityDescriptor, this.nativeId);
        }

        void initialize() {
            this.nativeId = Needle.self();
            Objects.requireNonNull(this.nativeId);
            if (this.initializer != null) {
                this.initializer.invoke();
            }
        }

        private void ensureInitialization() {
            if (this.nativeId == null) {
                throw new NeedleException("native id uninitialized, cannot access affinity information");
            }
        }

        @Override
        public Object nativeId() {
            return this.nativeId;
        }

        Delegate initializer(@Nullable Initializer initializer) {
            this.initializer = initializer;
            return this;
        }

        @FunctionalInterface
        static interface Initializer {
            public void invoke();
        }
    }
}

