/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.agent;

import javax.annotation.Nonnull;
import net.bytebuddy.asm.Advice;
import org.sheinbergon.needle.Needle;
import org.sheinbergon.needle.Pinned;
import org.sheinbergon.needle.agent.NeedleAgentConfiguration;
import org.sheinbergon.needle.agent.util.AffinityGroupMatcher;
import org.sheinbergon.needle.util.NeedleAffinity;

public final class AffinityAdvice {
    private AffinityAdvice() {
    }

    @Advice.OnMethodEnter
    public static void run() {
        try {
            Thread thread = Thread.currentThread();
            if (!AffinityAdvice.excluded(thread)) {
                NeedleAgentConfiguration.AffinityGroup group = AffinityGroupMatcher.forThread(thread);
                Needle.affinity(group.affinity());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean excluded(@Nonnull Thread thread) {
        Class<?> type = thread.getClass();
        return Pinned.class.isAssignableFrom(type) || type.isAnnotationPresent(NeedleAffinity.class);
    }
}

