/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.agent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.sheinbergon.needle.Pinned;
import org.sheinbergon.needle.agent.AffinityAdvice;
import org.sheinbergon.needle.agent.NeedleAgentConfiguration;
import org.sheinbergon.needle.agent.util.AffinityGroupMatcher;
import org.sheinbergon.needle.agent.util.YamlCodec;
import org.sheinbergon.needle.util.NeedleAffinity;

public final class NeedleAgent {
    private NeedleAgent() {
    }

    public static void premain(String arguments, Instrumentation instrumentation) throws Exception {
        File storage = Files.createTempDirectory("needle-agent-instrumentation", new FileAttribute[0]).toFile();
        NeedleAgent.setupBootstrapInjection(storage, instrumentation);
        NeedleAgent.agentConfiguration(arguments);
        AgentBuilder builder = new AgentBuilder.Default().disableClassFormatChanges().ignore(ElementMatchers.nameStartsWith("net.bytebuddy.")).with(AgentBuilder.TypeStrategy.Default.REDEFINE).with(AgentBuilder.RedefinitionStrategy.REDEFINITION).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(new AgentBuilder.InjectionStrategy.UsingInstrumentation(instrumentation, storage));
        AgentBuilder.Identified.Narrowable narrowable = NeedleAgent.matchers(builder);
        narrowable.transform(NeedleAgent::premainTransform).installOn(instrumentation);
    }

    public static void agentmain(String arguments, Instrumentation instrumentation) throws Exception {
        NeedleAgent.agentConfiguration(arguments);
        AgentBuilder builder = new AgentBuilder.Default().disableClassFormatChanges().ignore(ElementMatchers.nameStartsWith("net.bytebuddy.")).with(AgentBuilder.TypeStrategy.Default.REDEFINE).with(AgentBuilder.RedefinitionStrategy.REDEFINITION).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE);
        AgentBuilder.Identified.Narrowable narrowable = NeedleAgent.matchers(builder);
        narrowable.transform(NeedleAgent.agentmainTransform()).installOn(instrumentation);
    }

    private static AgentBuilder.Identified.Narrowable matchers(@Nonnull AgentBuilder builder) {
        return builder.type(ElementMatchers.not(ElementMatchers.isSubTypeOf(Pinned.class)).and(ElementMatchers.not(ElementMatchers.isAnnotatedWith(NeedleAffinity.class))).and(ElementMatchers.isSubTypeOf(Thread.class).or(ElementMatchers.is(Thread.class))));
    }

    private static DynamicType.Builder<?> premainTransform(@Nonnull DynamicType.Builder<?> builder, @Nonnull TypeDescription typeDescription, @Nullable ClassLoader classLoader, @Nonnull JavaModule module) {
        return builder.visit(Advice.to(AffinityAdvice.class).on(ElementMatchers.named("run")));
    }

    private static AgentBuilder.Transformer agentmainTransform() {
        return new AgentBuilder.Transformer.ForAdvice().include(NeedleAgent.class.getClassLoader()).advice(ElementMatchers.named("run"), AffinityAdvice.class.getName());
    }

    private static void setupBootstrapInjection(@Nonnull File storage, @Nonnull Instrumentation instrumentation) {
        ClassInjector.UsingInstrumentation.of(storage, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, instrumentation).inject(Map.of(new TypeDescription.ForLoadedType(AffinityAdvice.class), ClassFileLocator.ForClassLoader.read(AffinityAdvice.class)));
    }

    private static void agentConfiguration(@Nullable String arguments) throws MalformedURLException {
        Supplier<NeedleAgentConfiguration> supplier;
        if (arguments != null) {
            URL url = new URL(arguments);
            supplier = () -> YamlCodec.parseConfiguration(url);
        } else {
            supplier = () -> NeedleAgentConfiguration.DEFAULT;
        }
        AffinityGroupMatcher.setConfigurationSupplier(supplier);
    }
}

