/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.agent;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.math.NumberUtils;
import org.sheinbergon.needle.AffinityDescriptor;

public class NeedleAgentConfiguration {
    public static final NeedleAgentConfiguration DEFAULT = new NeedleAgentConfiguration().defaultAffinity(AffinityDescriptor.from(NumberUtils.LONG_ZERO));
    @Nullable
    private List<AffinityGroup> affinityGroups;
    @Nonnull
    private AffinityDescriptor defaultAffinity;

    @Nullable
    public List<AffinityGroup> affinityGroups() {
        return this.affinityGroups;
    }

    @Nonnull
    public AffinityDescriptor defaultAffinity() {
        return this.defaultAffinity;
    }

    public NeedleAgentConfiguration affinityGroups(@Nullable List<AffinityGroup> affinityGroups) {
        this.affinityGroups = affinityGroups;
        return this;
    }

    public NeedleAgentConfiguration defaultAffinity(@Nonnull AffinityDescriptor defaultAffinity) {
        if (defaultAffinity == null) {
            throw new NullPointerException("defaultAffinity is marked non-null but is null");
        }
        this.defaultAffinity = defaultAffinity;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NeedleAgentConfiguration)) {
            return false;
        }
        NeedleAgentConfiguration other = (NeedleAgentConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AffinityGroup> this$affinityGroups = this.affinityGroups();
        List<AffinityGroup> other$affinityGroups = other.affinityGroups();
        if (this$affinityGroups == null ? other$affinityGroups != null : !((Object)this$affinityGroups).equals(other$affinityGroups)) {
            return false;
        }
        AffinityDescriptor this$defaultAffinity = this.defaultAffinity();
        AffinityDescriptor other$defaultAffinity = other.defaultAffinity();
        return !(this$defaultAffinity == null ? other$defaultAffinity != null : !((Object)this$defaultAffinity).equals(other$defaultAffinity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NeedleAgentConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AffinityGroup> $affinityGroups = this.affinityGroups();
        result = result * 59 + ($affinityGroups == null ? 43 : ((Object)$affinityGroups).hashCode());
        AffinityDescriptor $defaultAffinity = this.defaultAffinity();
        result = result * 59 + ($defaultAffinity == null ? 43 : ((Object)$defaultAffinity).hashCode());
        return result;
    }

    public String toString() {
        return "NeedleAgentConfiguration(affinityGroups=" + this.affinityGroups() + ", defaultAffinity=" + this.defaultAffinity() + ")";
    }

    public static final class AffinityGroup {
        @Nonnull
        private AffinityDescriptor affinity;
        @Nullable
        private Qualifier qualifier;
        @Nullable
        private Matcher matcher;
        @Nonnull
        private String identifier;

        public boolean matches(@Nonnull String target) {
            return this.matcher.matches(target);
        }

        @Nonnull
        public AffinityDescriptor affinity() {
            return this.affinity;
        }

        @Nullable
        public Qualifier qualifier() {
            return this.qualifier;
        }

        @Nullable
        public Matcher matcher() {
            return this.matcher;
        }

        @Nonnull
        public String identifier() {
            return this.identifier;
        }

        public AffinityGroup affinity(@Nonnull AffinityDescriptor affinity) {
            if (affinity == null) {
                throw new NullPointerException("affinity is marked non-null but is null");
            }
            this.affinity = affinity;
            return this;
        }

        public AffinityGroup qualifier(@Nullable Qualifier qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public AffinityGroup matcher(@Nullable Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public AffinityGroup identifier(@Nonnull String identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            this.identifier = identifier;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AffinityGroup)) {
                return false;
            }
            AffinityGroup other = (AffinityGroup)o;
            AffinityDescriptor this$affinity = this.affinity();
            AffinityDescriptor other$affinity = other.affinity();
            if (this$affinity == null ? other$affinity != null : !((Object)this$affinity).equals(other$affinity)) {
                return false;
            }
            Qualifier this$qualifier = this.qualifier();
            Qualifier other$qualifier = other.qualifier();
            if (this$qualifier == null ? other$qualifier != null : !((Object)((Object)this$qualifier)).equals((Object)other$qualifier)) {
                return false;
            }
            Matcher this$matcher = this.matcher();
            Matcher other$matcher = other.matcher();
            if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                return false;
            }
            String this$identifier = this.identifier();
            String other$identifier = other.identifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AffinityDescriptor $affinity = this.affinity();
            result = result * 59 + ($affinity == null ? 43 : ((Object)$affinity).hashCode());
            Qualifier $qualifier = this.qualifier();
            result = result * 59 + ($qualifier == null ? 43 : ((Object)((Object)$qualifier)).hashCode());
            Matcher $matcher = this.matcher();
            result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
            String $identifier = this.identifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public String toString() {
            return "NeedleAgentConfiguration.AffinityGroup(affinity=" + this.affinity() + ", qualifier=" + this.qualifier() + ", matcher=" + this.matcher() + ", identifier=" + this.identifier() + ")";
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
        @JsonSubTypes(value={@JsonSubTypes.Type(value=Prefix.class, name="PREFIX"), @JsonSubTypes.Type(value=Regex.class, name="REGEX")})
        public static interface Matcher {
            public boolean matches(@Nonnull String var1);

            public static final class Regex
            implements Matcher {
                @Nonnull
                private Pattern pattern;

                @Override
                public boolean matches(@Nonnull String target) {
                    return this.pattern.matcher(target).matches();
                }

                @Nonnull
                public Pattern pattern() {
                    return this.pattern;
                }

                public Regex pattern(@Nonnull Pattern pattern) {
                    if (pattern == null) {
                        throw new NullPointerException("pattern is marked non-null but is null");
                    }
                    this.pattern = pattern;
                    return this;
                }

                public String toString() {
                    return "NeedleAgentConfiguration.AffinityGroup.Matcher.Regex(pattern=" + this.pattern() + ")";
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Regex)) {
                        return false;
                    }
                    Regex other = (Regex)o;
                    Pattern this$pattern = this.pattern();
                    Pattern other$pattern = other.pattern();
                    return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Pattern $pattern = this.pattern();
                    result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
                    return result;
                }
            }

            public static final class Prefix
            implements Matcher {
                @Nonnull
                private String prefix;

                @Override
                public boolean matches(@Nonnull String target) {
                    return target.startsWith(this.prefix);
                }

                @Nonnull
                public String prefix() {
                    return this.prefix;
                }

                public Prefix prefix(@Nonnull String prefix) {
                    if (prefix == null) {
                        throw new NullPointerException("prefix is marked non-null but is null");
                    }
                    this.prefix = prefix;
                    return this;
                }

                public String toString() {
                    return "NeedleAgentConfiguration.AffinityGroup.Matcher.Prefix(prefix=" + this.prefix() + ")";
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Prefix)) {
                        return false;
                    }
                    Prefix other = (Prefix)o;
                    String this$prefix = this.prefix();
                    String other$prefix = other.prefix();
                    return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $prefix = this.prefix();
                    result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
                    return result;
                }
            }
        }

        public static enum Qualifier {
            NAME,
            CLASS;

        }
    }
}

