/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.agent.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.sheinbergon.needle.agent.NeedleAgentConfiguration;
import org.sheinbergon.needle.util.NeedleException;

public final class AffinityGroupMatcher {
    private static final String DEFAULT_AFFINITY_GROUP_IDENTIFIER = "default";
    private static final List<NeedleAgentConfiguration.AffinityGroup> CLASS_MATCHING_AFFINITY_GROUPS = Lists.newArrayList();
    private static final List<NeedleAgentConfiguration.AffinityGroup> NAME_MATCHING_AFFINITY_GROUPS = Lists.newArrayList();
    @Nonnull
    private static volatile Supplier<NeedleAgentConfiguration> configurationSupplier = () -> NeedleAgentConfiguration.DEFAULT;
    private static volatile boolean initialized = false;
    private static NeedleAgentConfiguration.AffinityGroup defaultAffinityGroup = null;

    private AffinityGroupMatcher() {
    }

    @Nonnull
    public static NeedleAgentConfiguration.AffinityGroup forThread(@Nonnull Thread thread) {
        if (!initialized) {
            AffinityGroupMatcher.initialize();
            initialized = true;
        }
        return AffinityGroupMatcher.forThreadName(thread).or(() -> AffinityGroupMatcher.forThreadClass(thread)).orElse(defaultAffinityGroup);
    }

    @Nonnull
    private static Optional<NeedleAgentConfiguration.AffinityGroup> forThreadName(@Nonnull Thread thread) {
        String target = thread.getName();
        return AffinityGroupMatcher.forTarget(target, NAME_MATCHING_AFFINITY_GROUPS);
    }

    @Nonnull
    private static Optional<NeedleAgentConfiguration.AffinityGroup> forThreadClass(@Nonnull Thread thread) {
        String target = thread.getClass().getName();
        return AffinityGroupMatcher.forTarget(target, CLASS_MATCHING_AFFINITY_GROUPS);
    }

    @Nonnull
    private static Optional<NeedleAgentConfiguration.AffinityGroup> forTarget(@Nonnull String target, @Nonnull Collection<NeedleAgentConfiguration.AffinityGroup> affinityGroups) {
        NeedleAgentConfiguration.AffinityGroup matched = null;
        for (NeedleAgentConfiguration.AffinityGroup group : affinityGroups) {
            if (!group.matches(target)) continue;
            matched = group;
            break;
        }
        return Optional.ofNullable(matched);
    }

    private static void initialize() {
        NeedleAgentConfiguration configuration = configurationSupplier.get();
        defaultAffinityGroup = AffinityGroupMatcher.defaultAffinityGroup(configuration);
        List<NeedleAgentConfiguration.AffinityGroup> affinityGroups = AffinityGroupMatcher.affinityGroups(configuration);
        block4: for (NeedleAgentConfiguration.AffinityGroup group : affinityGroups) {
            NeedleAgentConfiguration.AffinityGroup.Qualifier qualifier = group.qualifier();
            switch (qualifier) {
                case NAME: {
                    NAME_MATCHING_AFFINITY_GROUPS.add(group);
                    continue block4;
                }
                case CLASS: {
                    CLASS_MATCHING_AFFINITY_GROUPS.add(group);
                    continue block4;
                }
            }
            throw new NeedleException(String.format("Unsupported affinity group qualifier '%s'", new Object[]{qualifier}));
        }
    }

    @Nonnull
    private static NeedleAgentConfiguration.AffinityGroup defaultAffinityGroup(@Nonnull NeedleAgentConfiguration configuration) {
        return new NeedleAgentConfiguration.AffinityGroup().identifier(DEFAULT_AFFINITY_GROUP_IDENTIFIER).affinity(configuration.defaultAffinity());
    }

    @Nonnull
    private static List<NeedleAgentConfiguration.AffinityGroup> affinityGroups(@Nonnull NeedleAgentConfiguration configuration) {
        return ObjectUtils.defaultIfNull(configuration.affinityGroups(), List.of());
    }

    public static void setConfigurationSupplier(@Nonnull Supplier<NeedleAgentConfiguration> configurationSupplier) {
        if (configurationSupplier == null) {
            throw new NullPointerException("configurationSupplier is marked non-null but is null");
        }
        AffinityGroupMatcher.configurationSupplier = configurationSupplier;
    }
}

