/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.agent.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.sheinbergon.needle.AffinityDescriptor;
import org.sheinbergon.needle.agent.NeedleAgentConfiguration;
import org.sheinbergon.needle.agent.util.NeedleAgentException;
import org.sheinbergon.needle.util.NeedleException;

public final class YamlCodec {
    private static final ObjectReader JACKSON = new ObjectMapper(new YAMLFactory()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).addMixIn(AffinityDescriptor.class, AffinityDescriptorMixIn.class).addMixIn(Pattern.class, RegexPatternMixIn.class).readerFor(NeedleAgentConfiguration.class);

    private YamlCodec() {
    }

    @Nonnull
    public static NeedleAgentConfiguration parseConfiguration(@Nonnull URL url) throws NeedleException {
        try {
            return (NeedleAgentConfiguration)JACKSON.readValue(url);
        }
        catch (IOException iox) {
            throw new NeedleAgentException(iox);
        }
    }

    private static class RegexPatternDeserializer
    extends JsonDeserializer<Pattern> {
        private RegexPatternDeserializer() {
        }

        @Override
        public Pattern deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec codec = parser.getCodec();
            JsonNode node = (JsonNode)codec.readTree(parser);
            return Pattern.compile(node.asText());
        }
    }

    private static class AffinityDescriptorDeserializer
    extends JsonDeserializer<AffinityDescriptor> {
        private AffinityDescriptorDeserializer() {
        }

        @Override
        public AffinityDescriptor deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec codec = parser.getCodec();
            JsonNode node = (JsonNode)codec.readTree(parser);
            if (node.isTextual()) {
                return AffinityDescriptor.from(node.asText());
            }
            if (node.isIntegralNumber()) {
                return AffinityDescriptor.from(node.asLong());
            }
            throw new NeedleException(String.format("Unsupported affinity descriptor value node type - %s", node.getClass().getSimpleName()));
        }
    }

    @JsonDeserialize(using=RegexPatternDeserializer.class)
    private static interface RegexPatternMixIn {
    }

    @JsonDeserialize(using=AffinityDescriptorDeserializer.class)
    private static interface AffinityDescriptorMixIn {
    }
}

