/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.jna.linux;

import javax.annotation.Nonnull;
import org.sheinbergon.needle.AffinityDescriptor;
import org.sheinbergon.needle.AffinityResolver;
import org.sheinbergon.needle.jna.linux.Libc;
import org.sheinbergon.needle.jna.linux.Libpthread;
import org.sheinbergon.needle.jna.linux.structure.CpuSet;

public final class LinuxAffinityResolver
extends AffinityResolver<Long> {
    public static final AffinityResolver<?> INSTANCE = new LinuxAffinityResolver();
    private final int pid = Libc.getpid();

    private static CpuSet cpuSet() {
        CpuSet set = new CpuSet();
        set.zero();
        return set;
    }

    @Override
    @Nonnull
    public Long self() {
        return Libpthread.pthread_self();
    }

    @Override
    public void thread(@Nonnull Long identifier, @Nonnull AffinityDescriptor affinity) {
        CpuSet set = LinuxAffinityResolver.cpuSet();
        set.__bits[0] = set.__bits[0] | affinity.mask();
        Libpthread.pthread_setaffinity_np(identifier, set.bytes(), set);
    }

    @Override
    @Nonnull
    public AffinityDescriptor thread(@Nonnull Long identifier) {
        CpuSet set = LinuxAffinityResolver.cpuSet();
        Libpthread.pthread_getaffinity_np(identifier, set.bytes(), set);
        long mask = set.__bits[0];
        return AffinityDescriptor.from(mask);
    }

    @Override
    @Nonnull
    protected AffinityDescriptor process() {
        CpuSet set = LinuxAffinityResolver.cpuSet();
        Libc.sched_getaffinity(this.pid, set.bytes(), set);
        long mask = set.__bits[0];
        return AffinityDescriptor.from(mask);
    }

    private LinuxAffinityResolver() {
    }
}

