/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.jna.win32;

import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import javax.annotation.Nonnull;
import org.sheinbergon.needle.AffinityDescriptor;
import org.sheinbergon.needle.AffinityResolver;
import org.sheinbergon.needle.jna.win32.Kernel32;

public final class Win32AffinityResolver
extends AffinityResolver<WinNT.HANDLE> {
    public static final AffinityResolver<?> INSTANCE = new Win32AffinityResolver();
    private static final WinDef.BOOL TRUE = new WinDef.BOOL(true);
    private static final WinDef.DWORD ALL_ACCESS = new WinDef.DWORD(2032639L);

    private static BaseTSD.DWORD_PTR processAffinity() {
        WinNT.HANDLE processHandle = Kernel32.GetCurrentProcess();
        LongByReference systemAffinityMask = new LongByReference();
        LongByReference processAffinityMask = new LongByReference();
        Kernel32.GetProcessAffinityMask(processHandle, processAffinityMask, systemAffinityMask);
        return new BaseTSD.DWORD_PTR(processAffinityMask.getValue());
    }

    @Override
    @Nonnull
    public WinNT.HANDLE self() {
        WinDef.DWORD id = Kernel32.GetCurrentThreadId();
        return Kernel32.OpenThread(ALL_ACCESS, TRUE, id);
    }

    @Override
    public synchronized void thread(@Nonnull WinNT.HANDLE handle, @Nonnull AffinityDescriptor affinity) {
        long mask = affinity.mask();
        BaseTSD.DWORD_PTR pointer = new BaseTSD.DWORD_PTR(mask);
        Kernel32.SetThreadAffinityMask(handle, pointer);
    }

    @Override
    @Nonnull
    public synchronized AffinityDescriptor thread(@Nonnull WinNT.HANDLE handle) {
        BaseTSD.DWORD_PTR current = Kernel32.SetThreadAffinityMask(handle, Win32AffinityResolver.processAffinity());
        Kernel32.SetThreadAffinityMask(handle, current);
        return AffinityDescriptor.from(current.longValue());
    }

    @Override
    @Nonnull
    protected AffinityDescriptor process() {
        return AffinityDescriptor.from(Win32AffinityResolver.processAffinity().longValue());
    }

    private Win32AffinityResolver() {
    }
}

