/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public abstract class AbstractGitHubOperations {
    public static final String API_URL_BASE = "https://api.github.com/";
    private final Logger log = LoggerFactory.getLogger(AbstractGitHubOperations.class);
    private final RestTemplate restTemplate;
    private final boolean isAuthorized;
    private final String apiUrlBase;

    public AbstractGitHubOperations(RestTemplate restTemplate, boolean isAuthorized) {
        this(restTemplate, isAuthorized, API_URL_BASE);
    }

    public AbstractGitHubOperations(RestTemplate restTemplate, boolean isAuthorized, String apiBaseUrl) {
        this.restTemplate = restTemplate;
        this.isAuthorized = isAuthorized;
        this.apiUrlBase = apiBaseUrl;
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                if (AbstractGitHubOperations.this.log.isWarnEnabled() && response.getStatusCode() != HttpStatus.NOT_FOUND) {
                    String bodyText = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.defaultCharset());
                    AbstractGitHubOperations.this.log.warn("Github API REST response body:" + bodyText);
                }
            }
        });
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected boolean isAuthorized() {
        return this.isAuthorized;
    }

    protected String getApiBaseUrl() {
        return this.apiUrlBase;
    }

    public UriTemplate buildUriTemplate(String path) {
        return new UriTemplate(this.buildUriString(path));
    }

    public URI buildUri(String path, Map<String, Object> uriVariables) {
        return new UriTemplate(this.buildUriString(path)).expand(uriVariables);
    }

    public URI buildUri(String path) {
        return this.buildUri(path, new HashMap<String, Object>(0));
    }

    public String buildUriString(String path) {
        return this.getApiBaseUrl() + path;
    }
}

