/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.auth;

import java.net.URI;
import org.siggici.connect.github.AbstractGitHubOperations;
import org.siggici.connect.github.auth.AuthorizationOperations;
import org.siggici.connect.github.auth.CreateNewTokenRequest;
import org.siggici.connect.github.auth.TokenRequest;
import org.siggici.connect.github.auth.TokenResponse;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.social.MissingAuthorizationException;
import org.springframework.web.client.RestTemplate;

public class AuthorizationTemplate
extends AbstractGitHubOperations
implements AuthorizationOperations {
    private final String apiBaseUrl;

    public AuthorizationTemplate(RestTemplate restTemplate, boolean authorized) {
        this(restTemplate, authorized, "https://api.github.com/");
    }

    public AuthorizationTemplate(RestTemplate restTemplate, boolean authorized, String apiBaseUrl) {
        super(restTemplate, authorized, apiBaseUrl);
        this.apiBaseUrl = apiBaseUrl;
    }

    @Override
    public TokenResponse createToken(String clientId, TokenRequest tokenRequest) {
        RequestEntity requestEntity = RequestEntity.put((URI)this.buildUri("authorizations/clients/" + clientId)).contentType(MediaType.APPLICATION_JSON).body((Object)tokenRequest);
        return (TokenResponse)this.getRestTemplate().exchange(requestEntity, TokenResponse.class).getBody();
    }

    @Override
    public TokenResponse createNewToken(CreateNewTokenRequest newTokenRequest) {
        RequestEntity requestEntity = RequestEntity.post((URI)this.buildUri("authorizations")).contentType(MediaType.APPLICATION_JSON).body((Object)newTokenRequest);
        return (TokenResponse)this.getRestTemplate().exchange(requestEntity, TokenResponse.class).getBody();
    }

    protected void requireAuthorization() {
        if (!this.isAuthorized()) {
            throw new MissingAuthorizationException(this.apiBaseUrl);
        }
    }
}

