/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.issue;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.siggici.connect.github.AbstractGitHubOperations;
import org.siggici.connect.github.issue.Issue;
import org.siggici.connect.github.issue.IssueRequest;
import org.siggici.connect.github.issue.IssuesOperations;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class IssuesTemplate
extends AbstractGitHubOperations
implements IssuesOperations {
    private final ParameterizedTypeReference<List<Issue>> issueListTypeRef = new ParameterizedTypeReference<List<Issue>>(){};

    public IssuesTemplate(RestTemplate restOperations, boolean authorized, String apiBaseUrl) {
        super(restOperations, authorized, apiBaseUrl);
    }

    public IssuesTemplate(RestTemplate restOperations, boolean authorized) {
        this(restOperations, authorized, "https://api.github.com/");
    }

    @Override
    public List<Issue> listAllIssues() {
        return (List)this.getRestTemplate().exchange(this.buildUri("/issues?per_page=25"), HttpMethod.GET, null, this.issueListTypeRef).getBody();
    }

    @Override
    public List<Issue> listUserIssues() {
        return (List)this.getRestTemplate().exchange(this.buildUri("/user/issues?per_page=25"), HttpMethod.GET, null, this.issueListTypeRef).getBody();
    }

    @Override
    public List<Issue> listOrganizationIssues(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return (List)this.getRestTemplate().exchange(this.buildUri("/orgs/{organization}/issues?per_page=25", uriVariables), HttpMethod.GET, null, this.issueListTypeRef).getBody();
    }

    @Override
    public Issue createIssue(IssueRequest issueRequest, String owner, String repo) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("owner", owner);
        uriVariables.put("repo", repo);
        URI uri = new UriTemplate(this.buildUriString("/repos/{owner}/{repo}/issues")).expand(uriVariables);
        RequestEntity entity = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)issueRequest);
        ResponseEntity responseEntity = this.getRestTemplate().exchange(entity, Issue.class);
        return (Issue)responseEntity.getBody();
    }
}

