/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.pagination;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.siggici.connect.github.pagination.LinkRelation;
import org.siggici.connect.github.pagination.RelationsPredicate;
import org.siggici.connect.github.pagination.StringToLinkRelation;

public class LinkRelationExtractor {
    private static final Splitter splitter = Splitter.on((String)",");
    private static final Function<String, LinkRelation> transformer = new StringToLinkRelation();

    public Optional<LinkRelation> extractLinkRelation(String linkHeaderValue, String relation) {
        Iterable splittedHeaderIterable = splitter.split((CharSequence)linkHeaderValue);
        Iterable linkRelations = Iterables.transform((Iterable)splittedHeaderIterable, transformer);
        linkRelations = Iterables.filter((Iterable)linkRelations, (Predicate)new RelationsPredicate(relation));
        return Optional.fromNullable((Object)Iterables.getFirst((Iterable)linkRelations, null));
    }
}

