/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.pagination;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.siggici.connect.github.pagination.LinkRelation;
import org.siggici.connect.github.pagination.LinkRelationExtractor;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;

public class PagingIterator<E>
implements Iterator<E> {
    private static final LinkRelationExtractor linkRelationExtractor = new LinkRelationExtractor();
    private final RestOperations restOperations;
    private URI uri;
    private Class<E> responseType;
    private ParameterizedTypeReference<E> parameterizedTypeReference;
    private E next;

    public PagingIterator(RestOperations restOperations, URI uri, Class<E> responseType) {
        Assert.notNull((Object)restOperations, (String)"restOperations should not be null");
        Assert.notNull((Object)uri, (String)"URI should not be null");
        Assert.notNull(responseType, (String)"ResponseType should never be null");
        this.restOperations = restOperations;
        this.uri = uri;
        this.responseType = responseType;
    }

    public PagingIterator(RestOperations restOperations, URI uri, ParameterizedTypeReference<E> parameterizedTypeReference) {
        Assert.notNull((Object)restOperations, (String)"restOperations should not be null");
        Assert.notNull((Object)uri, (String)"URI should not be null");
        Assert.notNull(parameterizedTypeReference, (String)"ParameteriedTypeReference should never be null");
        this.restOperations = restOperations;
        this.uri = uri;
        this.parameterizedTypeReference = parameterizedTypeReference;
    }

    @Override
    public boolean hasNext() {
        this.fetchFromGithub();
        return this.next != null;
    }

    @Override
    public E next() {
        this.fetchFromGithub();
        E r = this.next;
        if (r == null) {
            throw new NoSuchElementException();
        }
        this.next = null;
        return r;
    }

    protected void fetchFromGithub() {
        if (this.next != null) {
            return;
        }
        if (this.uri == null) {
            return;
        }
        ResponseEntity<E> entity = this.getReponseEntity();
        List headerValues = entity.getHeaders().get((Object)"Link");
        if (headerValues == null) {
            this.uri = null;
        } else {
            String first = (String)headerValues.get(0);
            if (StringUtils.hasText((String)first)) {
                Optional<LinkRelation> linkRelation = linkRelationExtractor.extractLinkRelation(first, "rel=\"next\"");
                this.uri = linkRelation.isPresent() ? URI.create(((LinkRelation)linkRelation.get()).getLink()) : null;
            }
        }
        this.next = entity.getBody();
    }

    protected ResponseEntity<E> getReponseEntity() {
        if (this.responseType != null) {
            return this.restOperations.exchange(this.uri, HttpMethod.GET, null, this.responseType);
        }
        return this.restOperations.exchange(this.uri, HttpMethod.GET, null, this.parameterizedTypeReference);
    }
}

