/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.social;

import javaslang.Tuple;
import javaslang.Tuple2;
import org.siggici.connect.github.Github;
import org.siggici.connect.github.user.GitHubUserProfile;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;

public class GithubAdapter<T extends Github>
implements ApiAdapter<T> {
    public boolean test(T api) {
        try {
            api.getUserOperations().getUserProfile().getLogin();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setConnectionValues(T api, ConnectionValues values) {
        GitHubUserProfile ghUserProfile = api.getUserOperations().getUserProfile();
        Tuple2<String, String> loginNameTuple = this.extractLoginName(ghUserProfile);
        values.setProviderUserId((String)loginNameTuple._1);
        values.setDisplayName((String)loginNameTuple._2);
    }

    public UserProfile fetchUserProfile(T api) {
        GitHubUserProfile ghUserProfile = api.getUserOperations().getUserProfile();
        Tuple2<String, String> loginNameTuple = this.extractLoginName(ghUserProfile);
        return new UserProfileBuilder().setUsername((String)loginNameTuple._1).setName((String)loginNameTuple._2).setEmail(ghUserProfile.getEmail()).build();
    }

    public void updateStatus(T api, String message) {
        throw new UnsupportedOperationException();
    }

    protected Tuple2<String, String> extractLoginName(GitHubUserProfile userProfile) {
        String login = userProfile.getLogin();
        String name = userProfile.getName();
        if (name.trim().isEmpty()) {
            name = login;
        }
        return Tuple.of((Object)login, (Object)name);
    }
}

