/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.organization;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.siggici.connect.github.AbstractGitHubOperations;
import org.siggici.connect.github.organization.ExtOrganization;
import org.siggici.connect.github.organization.GitHubOrganization;
import org.siggici.connect.github.organization.GitHubRepo;
import org.siggici.connect.github.organization.OrganizationOperations;
import org.siggici.connect.github.organization.OrganizationUpdate;
import org.siggici.connect.github.organization.Team;
import org.siggici.connect.github.organization.TeamRequest;
import org.siggici.connect.github.pagination.PagingIterator;
import org.siggici.connect.github.user.User;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class OrganizationTemplate
extends AbstractGitHubOperations
implements OrganizationOperations {
    private final ParameterizedTypeReference<List<User>> userListTypeRef = new ParameterizedTypeReference<List<User>>(){};
    private final ParameterizedTypeReference<List<GitHubOrganization>> orgaListTypeRef = new ParameterizedTypeReference<List<GitHubOrganization>>(){};
    private final ParameterizedTypeReference<List<Team>> teamListTypeRef = new ParameterizedTypeReference<List<Team>>(){};

    public OrganizationTemplate(RestTemplate restTemplate, boolean authorized) {
        this(restTemplate, authorized, "https://api.github.com/");
    }

    public OrganizationTemplate(RestTemplate restTemplate, boolean authorized, String apiBaseUrl) {
        super(restTemplate, authorized, apiBaseUrl);
    }

    @Override
    public List<GitHubRepo> listOrganizationRepositories(String organization, String type) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        RequestEntity requestEntity = new RequestEntity((MultiValueMap)this.getDefaultHeaders(), HttpMethod.GET, this.buildUri("orgs/{organization}/repos?per_page=100", uriVariables));
        ResponseEntity organizationsEntity = this.getRestTemplate().exchange(requestEntity, GitHubRepo[].class);
        return Arrays.asList((Object[])organizationsEntity.getBody());
    }

    @Override
    public boolean isTeamMember(String teamId, String username) {
        return this.isTeamMember(teamId, username, false);
    }

    @Override
    public boolean isTeamMember(String teamId, String username, boolean includePending) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", teamId);
        uriVariables.put("username", username);
        RequestEntity requestEntity = new RequestEntity((MultiValueMap)this.getDefaultHeaders(), HttpMethod.GET, this.buildUri("teams/{id}/members/{username}", uriVariables));
        ResponseEntity responseEntity = this.getRestTemplate().exchange(requestEntity, Object.class);
        return responseEntity.getStatusCode().equals((Object)HttpStatus.NO_CONTENT);
    }

    @Override
    public List<Team> listTeams(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        ArrayList<Team> teamList = new ArrayList<Team>();
        PagingIterator<List<Team>> iter = new PagingIterator<List<Team>>((RestOperations)this.getRestTemplate(), this.buildUri("/orgs/{organization}/teams?per_page=100", uriVariables), this.teamListTypeRef);
        while (iter.hasNext()) {
            teamList.addAll((Collection)iter.next());
        }
        return teamList;
    }

    @Override
    public Team getTeam(String teamId) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("teamId", teamId);
        RequestEntity requestEntity = new RequestEntity((MultiValueMap)this.getDefaultHeaders(), HttpMethod.GET, this.buildUri("teams/{teamId}", uriVariables));
        ResponseEntity organizationsEntity = this.getRestTemplate().exchange(requestEntity, Team.class);
        return (Team)organizationsEntity.getBody();
    }

    @Override
    public List<User> listMembers(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return this.fetchUsers("/orgs/{organization}/members?per_page=100", uriVariables);
    }

    @Override
    public List<User> listPublicMembers(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return this.fetchUsers("/orgs/{organization}/public_members?per_page=100", uriVariables);
    }

    protected List<User> fetchUsers(String path, Map<String, Object> uriVariables) {
        ArrayList<User> usersList = new ArrayList<User>();
        PagingIterator<List<User>> iter = new PagingIterator<List<User>>((RestOperations)this.getRestTemplate(), this.buildUri(path, uriVariables), this.userListTypeRef);
        while (iter.hasNext()) {
            usersList.addAll((Collection)iter.next());
        }
        return usersList;
    }

    @Override
    public boolean isMemberOfOrganization(String organization, String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        uriVariables.put("username", username);
        HttpStatus status = HttpStatus.NOT_FOUND;
        try {
            ResponseEntity responseEntity = this.getRestTemplate().getForEntity(this.buildUri("/orgs/{organization}/members/{username}", uriVariables), Void.class);
            status = responseEntity.getStatusCode();
        }
        catch (HttpClientErrorException httpClientErrorException) {
            // empty catch block
        }
        return HttpStatus.NO_CONTENT.equals((Object)status);
    }

    @Override
    public boolean isPublicMemberOfOrganization(String organization, String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        uriVariables.put("username", username);
        HttpStatus status = HttpStatus.NOT_FOUND;
        try {
            ResponseEntity responseEntity = this.getRestTemplate().getForEntity(this.buildUri("/orgs/{organization}/public_members/{username}", uriVariables), Void.class);
            status = responseEntity.getStatusCode();
        }
        catch (HttpClientErrorException httpClientErrorException) {
            // empty catch block
        }
        return HttpStatus.NO_CONTENT.equals((Object)status);
    }

    @Override
    public void removeFromOrganization(String organization, String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        uriVariables.put("username", username);
        this.getRestTemplate().delete(this.buildUri("/orgs/{organization}/members/{username}", uriVariables));
    }

    @Override
    public List<GitHubOrganization> listAllGithubOrganizations() {
        return this.listOrganizations("/organizations?per_page=100");
    }

    @Override
    public List<GitHubOrganization> listGithubOrganizations() {
        return this.listOrganizations("/user/orgs?per_page=100");
    }

    @Override
    public List<GitHubOrganization> listUserOrganizations(String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("username", username);
        return this.listOrganizations("/user/{username}/orgs?per_page=100", uriVariables);
    }

    protected List<GitHubOrganization> listOrganizations(String path) {
        return this.listOrganizations(path, Collections.emptyMap());
    }

    protected List<GitHubOrganization> listOrganizations(String path, Map<String, Object> uriVariables) {
        ArrayList<GitHubOrganization> result = new ArrayList<GitHubOrganization>();
        PagingIterator<List<GitHubOrganization>> iter = new PagingIterator<List<GitHubOrganization>>((RestOperations)this.getRestTemplate(), this.buildUri(path, uriVariables), this.orgaListTypeRef);
        while (iter.hasNext()) {
            result.addAll((Collection)iter.next());
        }
        return result;
    }

    @Override
    public ExtOrganization getOrganization(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return (ExtOrganization)this.getRestTemplate().getForObject(this.buildUri("/orgs/{organization}", uriVariables), ExtOrganization.class);
    }

    @Override
    public ExtOrganization updateOrganization(OrganizationUpdate update, String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        RequestEntity entity = RequestEntity.patch((URI)this.buildUri("/orgs/{organization}", uriVariables)).contentType(MediaType.APPLICATION_JSON).body((Object)update);
        return (ExtOrganization)this.getRestTemplate().exchange(entity, ExtOrganization.class).getBody();
    }

    @Override
    public Team getTeam(long teamId) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("teamid", teamId);
        return (Team)this.getRestTemplate().getForObject(this.buildUri("/teams/{teamid}", uriVariables), Team.class);
    }

    @Override
    public Team createTeam(String organization, TeamRequest teamRequest) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        RequestEntity entity = RequestEntity.post((URI)this.buildUri("/orgs/{organization}/teams", uriVariables)).contentType(MediaType.APPLICATION_JSON).body((Object)teamRequest);
        return (Team)this.getRestTemplate().exchange(entity, Team.class).getBody();
    }

    @Override
    public Team updateTeam(long teamId, TeamRequest teamRequest) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("teamid", teamId);
        RequestEntity entity = RequestEntity.patch((URI)this.buildUri("/teams/{teamid}", uriVariables)).contentType(MediaType.APPLICATION_JSON).body((Object)teamRequest);
        return (Team)this.getRestTemplate().exchange(entity, Team.class).getBody();
    }

    @Override
    public void deleteTeam(long teamId) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("teamid", teamId);
        this.getRestTemplate().delete(this.buildUri("/teams/{teamid}", uriVariables));
    }

    protected HttpHeaders getDefaultHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/vnd.github.v3+json");
        return headers;
    }
}

