/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.siggici.connect.github.AbstractGitHubOperations;
import org.siggici.connect.github.organization.GitHubRepo;
import org.siggici.connect.github.pagination.PagingIterator;
import org.siggici.connect.github.repository.AddDeployKeyRequest;
import org.siggici.connect.github.repository.CombinedStatus;
import org.siggici.connect.github.repository.GitHubDeployKey;
import org.siggici.connect.github.repository.GitHubWebhook;
import org.siggici.connect.github.repository.RepositoryOperations;
import org.siggici.connect.github.repository.Status;
import org.siggici.connect.github.repository.StatusRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class RepositoryTemplate
extends AbstractGitHubOperations
implements RepositoryOperations {
    private final Logger log = LoggerFactory.getLogger(RepositoryTemplate.class);
    private final ParameterizedTypeReference<List<Status>> statusListTypeRef = new ParameterizedTypeReference<List<Status>>(){};
    private final ParameterizedTypeReference<List<GitHubRepo>> repoListTypeRef = new ParameterizedTypeReference<List<GitHubRepo>>(){};

    public RepositoryTemplate(RestTemplate restTemplate, boolean authorized) {
        this(restTemplate, authorized, "https://api.github.com/");
    }

    public RepositoryTemplate(RestTemplate restTemplate, boolean authorized, String apiBaseUrl) {
        super(restTemplate, authorized, apiBaseUrl);
    }

    @Override
    public GitHubRepo getRepository(String user, String repo) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", user);
        uriVariables.put("repo", repo);
        return (GitHubRepo)this.getRestTemplate().getForObject(this.buildRepoUri("", uriVariables), GitHubRepo.class, new Object[0]);
    }

    @Override
    public List<GitHubRepo> getRepositories(String user) {
        ArrayList<GitHubRepo> result = new ArrayList<GitHubRepo>();
        PagingIterator<List<GitHubRepo>> iter = new PagingIterator<List<GitHubRepo>>((RestOperations)this.getRestTemplate(), this.buildUri("user/repos?per_page=100"), this.repoListTypeRef);
        while (iter.hasNext()) {
            result.addAll((Collection)iter.next());
        }
        return result;
    }

    @Override
    public List<GitHubDeployKey> getDeployKeys(String user, String repo) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", user);
        uriVariables.put("repo", repo);
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.buildRepoUri("/keys", uriVariables), GitHubDeployKey[].class, new Object[0]));
    }

    @Override
    public GitHubDeployKey getDeployKey(String user, String repo, int id) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", user);
        uriVariables.put("repo", repo);
        uriVariables.put("id", id);
        return (GitHubDeployKey)this.getRestTemplate().getForObject(this.buildRepoUri("/keys/{id}", uriVariables), GitHubDeployKey.class, new Object[0]);
    }

    @Override
    public GitHubDeployKey addDeployKey(String owner, String repo, String title, String key) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", owner);
        uriVariables.put("repo", repo);
        AddDeployKeyRequest request = new AddDeployKeyRequest(title, key);
        return (GitHubDeployKey)this.getRestTemplate().postForObject(this.buildRepoUri("/keys", uriVariables), (Object)request, GitHubDeployKey.class, new Object[0]);
    }

    @Override
    public void deleteDeployKey(String owner, String repo, int id) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", owner);
        uriVariables.put("repo", repo);
        uriVariables.put("id", id);
        this.getRestTemplate().delete(this.buildRepoUri("/keys/{id}"), new Object[0]);
    }

    @Override
    public List<GitHubWebhook> getWebhooks(String user, String repo) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", user);
        uriVariables.put("repo", repo);
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.buildRepoUri("/hooks", uriVariables), GitHubWebhook[].class, new Object[0]));
    }

    @Override
    public GitHubWebhook getWebhook(String user, String repo, String id) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", user);
        uriVariables.put("repo", repo);
        uriVariables.put("id", id);
        return (GitHubWebhook)this.getRestTemplate().getForObject(this.buildRepoUri("/hooks/{id}", uriVariables), GitHubWebhook.class, new Object[0]);
    }

    @Override
    public GitHubWebhook addWebhook(String user, String repo, Object request) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", user);
        uriVariables.put("repo", repo);
        return (GitHubWebhook)this.getRestTemplate().postForObject(this.buildRepoUri("/hooks", uriVariables), request, GitHubWebhook.class, new Object[0]);
    }

    @Override
    public void deleteWebhook(String user, String repo, String id) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("user", user);
        uriVariables.put("repo", repo);
        uriVariables.put("id", id);
        this.getRestTemplate().delete(this.buildRepoUri("/hooks/{id}", uriVariables), new Object[0]);
    }

    private String buildRepoUri(String path) {
        return this.buildUri("repos/{user}/{repo}" + path).toString();
    }

    private String buildRepoUri(String path, Map<String, Object> uriVariables) {
        return this.buildUri("repos/{user}/{repo}" + path, uriVariables).toString();
    }

    @Override
    public Status createStatus(String owner, String repository, String sha, StatusRequest body) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("owner", owner);
        uriVariables.put("repository", repository);
        uriVariables.put("sha", sha);
        URI uri = new UriTemplate(this.buildUriString("/repos/{owner}/{repository}/statuses/{sha}")).expand(uriVariables);
        RequestEntity entity = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)body);
        ResponseEntity responseEntity = this.getRestTemplate().exchange(entity, Status.class);
        return (Status)responseEntity.getBody();
    }

    @Override
    public List<Status> listStatuses(String owner, String repository, String ref) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("owner", owner);
        uriVariables.put("repository", repository);
        uriVariables.put("ref", ref);
        return (List)this.getRestTemplate().exchange(this.buildUri("/repos/{owner}/{repository}/commits/{ref}/statuses", uriVariables), HttpMethod.GET, null, this.statusListTypeRef).getBody();
    }

    @Override
    public CombinedStatus getCombinedStatus(String owner, String repository, String ref) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("owner", owner);
        uriVariables.put("repository", repository);
        uriVariables.put("ref", ref);
        return (CombinedStatus)this.getRestTemplate().exchange(this.buildUri("/repos/{owner}/{repository}/commits/{ref}/status", uriVariables), HttpMethod.GET, null, CombinedStatus.class).getBody();
    }

    protected HttpHeaders getDefaultHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/vnd.github.v3+json");
        return headers;
    }
}

