/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.user;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.siggici.connect.github.AbstractGitHubOperations;
import org.siggici.connect.github.user.Email;
import org.siggici.connect.github.user.ExtPubKey;
import org.siggici.connect.github.user.GitHubUserProfile;
import org.siggici.connect.github.user.PubKey;
import org.siggici.connect.github.user.PubKeyInput;
import org.siggici.connect.github.user.UserOperations;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.web.client.RestTemplate;

public class UserTemplate
extends AbstractGitHubOperations
implements UserOperations {
    public static final String USER_EMAILS_PATH = "/user/emails";
    private final ParameterizedTypeReference<List<Email>> emailListTypeRef = new ParameterizedTypeReference<List<Email>>(){};
    private final ParameterizedTypeReference<List<ExtPubKey>> extPubKeyListTypeRef = new ParameterizedTypeReference<List<ExtPubKey>>(){};
    private final ParameterizedTypeReference<List<PubKey>> pubKeyListTypeRef = new ParameterizedTypeReference<List<PubKey>>(){};

    public UserTemplate(RestTemplate restTemplate, boolean authorized) {
        this(restTemplate, authorized, "https://api.github.com/");
    }

    public UserTemplate(RestTemplate restTemplate, boolean authorized, String apiBaseUrl) {
        super(restTemplate, authorized, apiBaseUrl);
    }

    @Override
    public String getProfileId() {
        return this.getUserProfile().getLogin();
    }

    @Override
    public GitHubUserProfile getUserProfile() {
        return (GitHubUserProfile)this.getRestTemplate().getForObject(this.buildUri("user"), GitHubUserProfile.class);
    }

    @Override
    public List<Email> listEmails() {
        return Arrays.asList((Object[])this.getRestTemplate().getForEntity(this.buildUriString(USER_EMAILS_PATH), Email[].class, new Object[0]).getBody());
    }

    @Override
    public List<Email> addEmails(String ... emails) {
        return this.addEmails(Arrays.asList(emails));
    }

    @Override
    public List<Email> addEmails(List<String> emails) {
        RequestEntity reqEntity = RequestEntity.post((URI)this.buildUri(USER_EMAILS_PATH)).contentType(MediaType.APPLICATION_JSON).body(emails);
        return (List)this.getRestTemplate().exchange(reqEntity, this.emailListTypeRef).getBody();
    }

    @Override
    public void deleteEmails(String ... emails) {
        this.deleteEmails(Arrays.asList(emails));
    }

    @Override
    public void deleteEmails(List<String> emails) {
        RequestEntity reqEntity = RequestEntity.method((HttpMethod)HttpMethod.DELETE, (URI)this.buildUri(USER_EMAILS_PATH)).contentType(MediaType.APPLICATION_JSON).body(emails);
        this.getRestTemplate().exchange(reqEntity, Void.class);
    }

    @Override
    public List<PubKey> listPublicKeys(String username) {
        HashMap<String, Object> uriVariabels = new HashMap<String, Object>(0);
        uriVariabels.put("username", username);
        RequestEntity reqEntity = RequestEntity.get((URI)this.buildUri("/users/{username}/keys", uriVariabels)).build();
        return (List)this.getRestTemplate().exchange(reqEntity, this.pubKeyListTypeRef).getBody();
    }

    @Override
    public List<ExtPubKey> listPublicKeys() {
        return (List)this.getRestTemplate().exchange(this.buildUri("/user/keys"), HttpMethod.GET, null, this.extPubKeyListTypeRef).getBody();
    }

    @Override
    public ExtPubKey getPublicKey(long id) {
        HashMap<String, Object> uriVariabels = new HashMap<String, Object>(0);
        uriVariabels.put("id", id);
        return (ExtPubKey)this.getRestTemplate().getForObject(this.buildUri("/user/keys/{id}", uriVariabels), ExtPubKey.class);
    }

    @Override
    public ExtPubKey createPublicKey(PubKeyInput pubKey) {
        RequestEntity reqEntity = RequestEntity.post((URI)this.buildUri(USER_EMAILS_PATH)).contentType(MediaType.APPLICATION_JSON).body((Object)pubKey);
        return (ExtPubKey)this.getRestTemplate().exchange(reqEntity, ExtPubKey.class).getBody();
    }

    @Override
    public void deletePublicKey(long id) {
        HashMap<String, Object> uriVariabels = new HashMap<String, Object>(0);
        uriVariabels.put("id", id);
        this.getRestTemplate().delete(this.buildUri("/user/keys/{id}", uriVariabels));
    }
}

