/*
 * Decompiled with CFR 0.152.
 */
package org.signserver.deploytools.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractModuleDescriptorsProcessor {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private File modsDir;
    private String rootSet;
    private String libSet;
    private String configRootSet;
    private String configConfSet;
    private String applicationXml;
    private String enabledModules;
    private boolean allEnabled;

    public Map<String, String> process() {
        String contextRoot = this.getProperty("httpserver.context.root");
        HashMap<String, String> result = new HashMap<String, String>();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".properties");
            }
        };
        HashSet<String> libJars = new HashSet<String>();
        HashSet<String> rootJars = new HashSet<String>();
        HashSet<String> configRootFiles = new HashSet<String>();
        HashSet<String> configConfFiles = new HashSet<String>();
        StringBuilder xmlBuff = new StringBuilder();
        StringBuilder enabledModulesBuff = new StringBuilder();
        File[] propertyFiles = this.modsDir.listFiles(filter);
        Arrays.sort(propertyFiles, new FileNameComparator());
        for (File file : propertyFiles) {
            this.log("Processing: " + file, 3);
            Properties properties = AbstractModuleDescriptorsProcessor.loadProperties(file);
            String name = properties.getProperty("module.name");
            boolean enabled = this.allEnabled || Boolean.parseBoolean(this.getProperty(name + ".enabled"));
            this.log("Module " + name + ": " + (enabled ? "enabled" : "disabled"), 1);
            if (enabled) {
                String type;
                String toConfigConf;
                xmlBuff.append("\n    <!-- Enabled: ").append(name).append(" -->");
                enabledModulesBuff.append(name).append(",");
                this.setPropertiesWithPrefix(name, properties);
                String toRoot = properties.getProperty("to.root");
                List<String> toRootList = Arrays.asList(toRoot.split(","));
                rootJars.addAll(toRootList);
                this.log("To root: " + toRootList.toString(), 3);
                String toLib = properties.getProperty("to.lib");
                List<String> toLibList = Arrays.asList(toLib.split(","));
                libJars.addAll(toLibList);
                this.log("To lib: " + toLibList.toString(), 3);
                String toConfigRoot = properties.getProperty("to.config");
                if (toConfigRoot != null) {
                    List<String> toConfigList = Arrays.asList(toConfigRoot.split(","));
                    configRootFiles.addAll(toConfigList);
                    this.log("To config root: " + toConfigList.toString(), 3);
                }
                if ((toConfigConf = properties.getProperty("to.config.conf")) != null) {
                    List<String> toConfigList = Arrays.asList(toConfigConf.split(","));
                    configConfFiles.addAll(toConfigList);
                    this.log("To config conf: " + toConfigList.toString(), 3);
                }
                if ((type = properties.getProperty("module.type", "lib")).equalsIgnoreCase("ejb")) {
                    String ejb = properties.getProperty("module.ejb");
                    if (ejb == null) {
                        this.log("No module.ejb defined", 1);
                    } else {
                        xmlBuff.append("\n    <module>\n").append("        <ejb>").append(ejb).append("</ejb>\n").append("    </module>");
                    }
                } else if (type.equalsIgnoreCase("war")) {
                    String modContextRoot;
                    String webUri = properties.getProperty("module.web.web-uri");
                    String modContext = properties.getProperty("module.web.context");
                    if (modContext == null) {
                        modContextRoot = properties.getProperty("module.web.context-root");
                        this.log("Using specified absolute module.web.context-root instead of a relative module.web.context", 3);
                    } else {
                        modContextRoot = contextRoot + modContext;
                        this.log("Using specified relative module.web.context", 3);
                    }
                    xmlBuff.append("\n    <module>\n").append("        <web>\n").append("            <web-uri>").append(webUri).append("</web-uri>\n").append("            <context-root>").append(modContextRoot).append("</context-root>\n").append("        </web>\n").append("    </module>");
                }
                String postprocessFiles = properties.getProperty("postprocess.files", "");
                result.put("postprocess." + name + ".files", postprocessFiles);
                for (String item : postprocessFiles.split(",")) {
                    result.put("postprocess." + item + ".src", properties.getProperty("postprocess." + item + ".src"));
                    result.put("postprocess." + item + ".includes", properties.getProperty("postprocess." + item + ".includes"));
                }
                continue;
            }
            xmlBuff.append("\n    <!-- Disabled: ").append(name).append(" -->");
        }
        result.put(this.libSet, AbstractModuleDescriptorsProcessor.getAsString(libJars, "-empty-list-"));
        result.put(this.rootSet, AbstractModuleDescriptorsProcessor.getAsString(rootJars, "-empty-list-"));
        if (this.configRootSet != null) {
            result.put(this.configRootSet, AbstractModuleDescriptorsProcessor.getAsString(configRootFiles, "-empty-list-"));
        }
        if (this.configConfSet != null) {
            result.put(this.configConfSet, AbstractModuleDescriptorsProcessor.getAsString(configConfFiles, "-empty-list-"));
        }
        result.put(this.applicationXml, xmlBuff.toString());
        result.put(this.enabledModules, enabledModulesBuff.toString());
        return result;
    }

    private static String getAsString(Set<String> set, String emptyValue) {
        if (set.isEmpty()) {
            return emptyValue;
        }
        StringBuilder buff = new StringBuilder();
        for (String item : set) {
            if (item.isEmpty()) continue;
            buff.append(item).append(", ");
        }
        return buff.toString();
    }

    private void setPropertiesWithPrefix(String prefix, Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            String newName = prefix + "." + key;
            this.setProperty(newName, properties.getProperty(key));
            this.log("Setting property " + newName, 3);
        }
    }

    protected abstract void log(String var1, int var2);

    public String getLibSet() {
        return this.libSet;
    }

    public void setLibSet(String libSet) {
        this.libSet = libSet;
    }

    public String getRootSet() {
        return this.rootSet;
    }

    public void setRootSet(String rootSet) {
        this.rootSet = rootSet;
    }

    public String getConfigRootSet() {
        return this.configRootSet;
    }

    public void setConfigRootSet(String configSet) {
        this.configRootSet = configSet;
    }

    public String getConfigConfSet() {
        return this.configConfSet;
    }

    public void setConfigConfSet(String configSet) {
        this.configConfSet = configSet;
    }

    public File getModsDir() {
        return this.modsDir;
    }

    public void setModsDir(File modsDir) {
        this.modsDir = modsDir;
    }

    public String getApplicationXml() {
        return this.applicationXml;
    }

    public void setApplicationXml(String applicationXml) {
        this.applicationXml = applicationXml;
    }

    public String getEnabledModules() {
        return this.enabledModules;
    }

    public void setEnabledModules(String enabledModules) {
        this.enabledModules = enabledModules;
    }

    public boolean isAllEnabled() {
        return this.allEnabled;
    }

    public void setAllEnabled(boolean allEnabled) {
        this.allEnabled = allEnabled;
    }

    private static Properties loadProperties(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract String getProperty(String var1);

    protected abstract void setProperty(String var1, String var2);

    private static class FileNameComparator
    implements Comparator<File> {
        private FileNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareTo(f2.getName());
        }
    }
}

