/*
 * Decompiled with CFR 0.152.
 */
package org.signserver.deploytools.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.text.StrSubstitutor;

public abstract class AbstractModulesPostProcessor {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private String modules;
    private String destDir;

    public void process() {
        if (this.modules == null) {
            throw new RuntimeException("Attribute 'modules' not specified");
        }
        if (this.destDir == null) {
            throw new RuntimeException("Attribute 'destDir' not specified");
        }
        List<String> modulesList = AbstractModulesPostProcessor.asList(this.modules);
        this.log("Modules: " + modulesList, 4);
        for (String module : modulesList) {
            List<String> postProcessFilesList;
            String postProcessFiles = this.getProperty(module + ".postprocess.files");
            if (postProcessFiles == null || (postProcessFilesList = AbstractModulesPostProcessor.asList(postProcessFiles)).isEmpty()) continue;
            this.log("Post processing module: " + module, 1);
            String moduleType = this.getProperty(module + ".module.type");
            this.log("    module.type: " + moduleType, 3);
            this.log("    Files to process: " + postProcessFilesList, 3);
            for (String postProcessFile : postProcessFilesList) {
                try {
                    String dest = this.getProperty(module + "." + postProcessFile + ".dest");
                    if (dest == null) {
                        dest = "";
                    }
                    this.log("    " + postProcessFile + ".dest: " + dest, 4);
                    String src = this.getProperty(module + "." + postProcessFile + ".src");
                    this.log("    " + postProcessFile + ".src: " + src, 4);
                    String includes = this.getProperty(module + "." + postProcessFile + ".includes");
                    this.log("    " + postProcessFile + ".includes: " + includes, 4);
                    String destfile = this.getDestDir() + "/" + dest + src;
                    this.replaceInJar(includes, this.getBaseDir() + "/lib/" + src, destfile, this.getProperties());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private static List<String> asList(String items) {
        LinkedList<String> result = new LinkedList<String>();
        for (String item : items.split(",")) {
            if ((item = item.trim()).isEmpty()) continue;
            result.add(item);
        }
        return result;
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    protected void replaceInJar(String replaceincludes, String src, String destfile, Map properties) throws IOException {
        try {
            this.log("Replace " + replaceincludes + " in " + src + " to " + destfile, 3);
            File srcFile = new File(src);
            if (!srcFile.exists()) {
                throw new FileNotFoundException(srcFile.getAbsolutePath());
            }
            HashSet<String> replaceFiles = new HashSet<String>();
            String[] rfiles = replaceincludes.split(",");
            for (int i = 0; i < rfiles.length; ++i) {
                rfiles[i] = rfiles[i].trim();
            }
            replaceFiles.addAll(Arrays.asList(rfiles));
            this.log("Files to replace: " + replaceFiles, 2);
            ZipFile zipSrc = new ZipFile(srcFile);
            ZipOutputStream zipDest = new ZipOutputStream(new FileOutputStream(destfile));
            Enumeration<? extends ZipEntry> entries = zipSrc.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) {
                    zipDest.putNextEntry(entry);
                    continue;
                }
                if (replaceFiles.contains(name)) {
                    name = name + " [REPLACE]";
                    this.log(name, 3);
                    ZipEntry newEntry = new ZipEntry(entry.getName());
                    newEntry.setComment(entry.getComment());
                    newEntry.setExtra(entry.getExtra());
                    zipDest.putNextEntry(newEntry);
                    StringBuffer oldDocument = AbstractModulesPostProcessor.stringBufferFromFile(zipSrc.getInputStream(entry));
                    this.log("Before replace ********\n" + oldDocument.toString() + "\n", 4);
                    StrSubstitutor sub = new StrSubstitutor(properties);
                    StringBuffer newerDocument = this.commentReplacement(oldDocument, properties);
                    String newDocument = sub.replace(newerDocument);
                    this.log("After replace ********\n" + newDocument + "\n", 4);
                    byte[] newBytes = newDocument.getBytes("UTF-8");
                    entry.setSize(newBytes.length);
                    AbstractModulesPostProcessor.copy(new ByteArrayInputStream(newBytes), zipDest);
                } else {
                    name = name + " []";
                    this.log(name, 3);
                    zipDest.putNextEntry(entry);
                    AbstractModulesPostProcessor.copy(zipSrc.getInputStream(entry), zipDest);
                }
                zipDest.closeEntry();
            }
            zipSrc.close();
            zipDest.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buff = new byte[10240];
        while ((read = in.read(buff)) != -1) {
            out.write(buff, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer stringBufferFromFile(InputStream in) throws IOException {
        StringBuffer result = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    protected StringBuffer commentReplacement(StringBuffer oldDocument, Map properties) throws IOException {
        String line;
        StringBuffer result = new StringBuffer();
        Pattern pattern = Pattern.compile(".*<!--COMMENT-REPLACEMENT\\(([a-zA-Z\\._]+)\\)-->.*");
        BufferedReader reader = new BufferedReader(new StringReader(oldDocument.toString()));
        while ((line = reader.readLine()) != null) {
            String propertyName;
            Matcher m = pattern.matcher(line);
            if (m.matches() && (propertyName = m.group(1)) != null) {
                Object value = properties.get(propertyName);
                if (value instanceof String) {
                    this.log("Comment replacement for " + propertyName, 3);
                    line = line.replace("<!--COMMENT-REPLACEMENT(" + propertyName + ")-->", (String)value);
                } else {
                    this.log("No comment replacement value for " + propertyName, 3);
                }
            }
            result.append(line).append("\n");
        }
        return result;
    }

    protected abstract void log(String var1, int var2);

    protected abstract String getProperty(String var1);

    protected abstract void setProperty(String var1, String var2);

    private String getBaseDir() {
        return this.getProperty("basedir");
    }

    protected abstract Map getProperties();
}

